#directory "/home/moi/enseignement/Informatique/bibs/";; (* Changer l’adresse ici bien sûr *)
#use "arbreLex.ml";;


let bon_fils x (Noeud(term, fils))=
  (*
    Entrée : un carctère, et un arbre
    Sortie :le fils de la racine dont l’arête est étiquetée par x.
   *)
  
  match 
      List.filter
        (fun (lettre, f)->lettre=x)
        fils
     with
  |[] -> failwith "pas de mots se poursuivant par cette lette"
  |[_, t] -> t
  |_ -> failwith "arbre mal construit : plusieurs branches ont la mêm, lettre"
;;

List.map
  string_of_mot
  (mots_of_arbre  (bon_fils 'z' dico_francais));;


let rec sous_arbre m  = function
  (*
    Entrée : un arbre lex a.
    Sortie : le sous-arbre de a dont la racine est atteinte en lisant m. C’est donc l’arbre de tous les mots n tels que mn est dans a. 
   *)
  |a when m=[] -> a
  |Noeud(_, fils) ->  sous_arbre_foret m fils

and sous_arbre_foret (x::suite_m) = function
  |(lettre, fils)::q when lettre = x -> (* C’est la bonne branche *)
    sous_arbre suite_m fils
  |(lettre, fils)::q when lettre < x -> (* la bonne branche est plus loin *)
    sous_arbre_foret (x::suite_m) q
  | _ -> Noeud(false, []) (* Pas de bonne branche *)
;;


List.map
  string_of_mot
  ( mots_of_arbre (sous_arbre (mot_of_string "quater") dico_francais));;



let nb_feuilles_a_bonne_prof (a: arbreLex) (n:int) =
  (* Renvoie le nb de feuilles de a dont la profondeur n’est pas congrue à 0 modulo n *)
  
  let rec aux p = function
      (* p : profondeur actuelle modulo n *)
    |Noeud(_, []) when p=0 -> 0
    |Noeud(_, []) -> 1
    |Noeud(_, fils) -> aux_foret ((p+1) mod n) fils

  and aux_foret p = function
    |[] -> 0
    |(_,f)::q -> aux p f + aux_foret p q

  in
  aux 0 a
;;

nb_feuilles_a_bonne_prof dico_francais 3;;


let meilleur_fils n (Noeud(_,fils)) = 
  (* 
     Entrée : un arbre a
     Sortie : le couple  (fils de a qui a le plus de feuilles dont la profondeur n’est pas congrue à 0 modulo n, lettre correspondante ). 
   *)

  let rec aux = function
      (*
        Entrée : une forêt.
        Sortie : le triplet (le fils ayant le plus de feuilles dont la profondeur n’est pas congrue à 0 modulo n, le nb de feuilles correspondant, la lettre correspondante)
       *)
  
  | [] -> -1, feuille, 'z'
  | [(lettre, f)] -> nb_feuilles_a_bonne_prof f n , f, lettre
  | (lettre, f)::q ->
    let nf = nb_feuilles_a_bonne_prof f n
    and nq, fq, lq = aux q in
    if nf > nq then nf, f, lettre
    else nq, fq, lq

  in let _, f, l = aux fils
     in f,l
;;


let partie () =
  (* Partie deux joueurs contre l’ordi *)
  print_string "Partie deux joueurs lancée\n";
  flush_all();(* Sinon Caml attend la fin de l’exécution du programme pour afficher *)

  let rec aux a j =
    (* 
       Entrée : a, arbre des suffixes possibles.
                j, le joueur actuel. 1=humain, -1=ordi
     *)

    Printf.printf "%i feuilles restantes\n" (nb_feuilles a);
    flush_all();
    
    if a = feuille then  Printf.printf "Le joueur %i a perdu" j
    
    else if j = 1 then
        let lettre = (read_line()).[0] in
        aux (bon_fils lettre a ) (-j)

    else
      let fils, lettre = meilleur_fils 2 a in
      begin
        print_char lettre;
        flush_all();
        aux fils (-j)
      end
  in
  aux dico_francais 1
;;


(*
partie ();;
 *)
(* pour lancer une partie, décommenter la ligne ci-dessus et  lancer "ocaml ce_fichier.ml" dans un terminal. *)



(* Minimax *)

let score_de_base a n = 
  (* Renvoie : nb de feuilles à profondeur non divisible par n - nb de feuilles à profondeur divisible par n *)
  let rec aux p = function
    (* p : profondeur actuelle modulo n *)
    |Noeud(_, []) when p=0 -> -1
    |Noeud(_, []) -> 1
    |Noeud(_, fils) -> aux_foret ((p+1) mod n) fils

  and aux_foret p = function
    |[] -> 0
    |(_,f)::q -> aux p f + aux_foret p q

  in
  aux 0 a
;;



let rec mini_list (l:int list) = match l with
  |[] -> failwith "liste vide"
  |[t]->t
  |t::q -> min t (mini_list q)
;;

let non_vides (fils:fils)= List.filter (fun (_,a)-> a <> feuille) fils;;



let rec score (Noeud(term, fils)) n j p =
  (* Évaluation de score selon l’algo du minimax
     Nombre d’autant plus grand que j a des chances de gagner.
   *)
  
  if fils = [] then min_int (* j a perdu *)
  
  else if p = 0 then
    score_de_base (Noeud(term, fils)) n
  
  else
    (* Calculer le score de -j pour toutes les possibs et prendre - le min *)
    - mini_list
      (
        List.map
          (fun (_, f) -> score f n (-j) (p-1))
          (fils)
      )
;;

score dico_francais 2 1 1;;
min_int;;


let meilleur_fils_minimax n (Noeud(term, fils)) j p =
    let rec aux = function
      (*
        Entrée : une forêt.
        Sortie : le triplet (meilleur fils, son score, la lettre correspondante)
       *)
  
  | [] -> -1, feuille, 'z'
  | [(lettre, f)] -> score f n j p , f, lettre
  | (lettre, f)::q ->
    let score_f = score f n j p
    and score_q, fq, lq = aux q in
    if score_f > score_q then score_f, f, lettre
    else score_q, fq, lq

  in let _, f, l = aux (non_vides fils)
     in f,l
;;

snd (meilleur_fils_minimax 2 dico_francais 1 3);;



let partie_minimax p =
  (* 
     p (entier) : niveau de difficulté. En pratique, nombre de coups à l’avance que l’ordinateur prévoit.
     Partie deux joueurs contre l’ordi *)   
  print_string "Partie deux joueurs lancée. Vous êtes le joueur 1.\n";
  flush_all();(* Sinon Caml attend la fin de l’exécution du programme pour afficher *)

  let rec aux a j =
    (* 
       Entrée : a, arbre des suffixes possibles.
                j, le joueur actuel. 1=humain, -1=ordi
     *)

    Printf.printf "%i feuilles restantes\n" (nb_feuilles a);
    flush_all();
    
    if a = feuille then  Printf.printf "Le joueur %i a perdu" j
    
    else if j = 1 then
        let lettre = (read_line()).[0] in
        aux (bon_fils lettre a ) (-j)

    else
      let fils, lettre = meilleur_fils_minimax 2 a j p in
      begin
        print_char lettre;print_newline();
        flush_all();
        aux fils (-j)
      end
  in
  aux dico_francais 1
;;


partie_minimax 3;;
