type case = int*int;;

let translation (x,y) (dx,dy)=
  x+dx, y+dy
;;

let deplacements = [
    (2,1); (2,-1); (-2,1); (-2,-1);
    (1,2); (1,-2); (-1,2); (-1,-2)
  ]
;;

let est_dans_le_plateau (x,y) =
  0<= x && x<8 && 0<= y && y<8
;;

let cases_accessibles c dejaVue =
  (* Liste des cases accessibles et non déjà vues depuis la case c *)
  List.filter
    (fun x -> est_dans_le_plateau x && not (Hashtbl.mem dejaVue x))
    (
      List.map
        (fun dep -> translation c dep )
        deplacements
    )
;;


let enfile_nelles_cases c iti f dejaVue =
  List.iter
    (fun x -> Queue.add (x::iti, x) f;
              Hashtbl.add dejaVue x true)
    (cases_accessibles c dejaVue)
;;
(* 

 *)


let trajet depart arrivee =
  (* Renvoie un itinéraire de longueur minimale pour déplacer le cavalier de la case départ vers la case arrivée.*)

  let aEssayer = Queue.create () (* File de couples (itinéraire, case) *)
  and fini = ref false
  and res = ref []
  and dejaVue = Hashtbl.create 42 in
  Queue.add ([], depart) aEssayer;
  Hashtbl.add dejaVue depart true;

  while not !fini && not (Queue.is_empty aEssayer) do
    let itineraire, case = Queue.take aEssayer in
    if case = arrivee then begin
        fini := true;
        res := itineraire
      end
    else
      enfile_nelles_cases case itineraire aEssayer dejaVue
  done;
  if !fini then
    !res
  else
    []
;;

trajet (0,0) (1,1);;

(* Version avec boucle récursive *)


let trajet2 depart arrivee =
  (* Renvoie un itinéraire de longueur minimale pour déplacer le cavalier de la case départ vers la case arrivée.*)

  let aEssayer = Queue.create ()
  and dejaVue = Hashtbl.create 42 in (* File de couples (itinéraire, case) *)
  Queue.add ([], depart) aEssayer;
  Hashtbl.add dejaVue depart true;
  
  let rec boucle () =
    if Queue.is_empty aEssayer then []
    else let (iti, case) = Queue.take aEssayer in
         if case=arrivee then iti
         else begin
             enfile_nelles_cases case iti aEssayer dejaVue;
             boucle()
           end
  in
  boucle ()
;;

trajet2 (1,1) (2,1);;

(* Purement récursive *)

#directory "/home/moi/enseignement/Informatique/bibs/";;
#use "files.ml";;
enfiled;;
defiled;;


let nelles_cases_enfiled c iti f dejaVue =
  List.fold_right
    enfiled
    (List.map
       (fun x -> Hashtbl.add dejaVue x true; (x::iti, x))
       (cases_accessibles c dejaVue)
    )
    f
;;



let trajet3 depart arrivee =

  let dejaVue = Hashtbl.create 42 in

  let rec boucle aEssayer =
    if aEssayer = fileVide then []
    else let (iti, case), suiteFile = defiled aEssayer in
         if case=arrivee then
           iti
         else
           boucle (nelles_cases_enfiled case iti suiteFile dejaVue )
  in

  Hashtbl.add dejaVue depart true;
  boucle (enfiled ([], depart) fileVide)
;;

trajet3 (1,1) (1,2);;
