type grille = int array array;;


let rec appartient  x = function
        |[] -> false
        |t::q when t=x  -> true
        |_::q           -> appartient x q
;;
 
 
let rec supprime  x = function
        |[] -> []
        |t::q when t=x  -> supprime x q
        |t::q           -> t::supprime x q
;;
 
 supprime 2 [1;2;3;4;5];;

(*- ajout -*)
let ajout x l=
    if appartient x l then l
    else x::l
;;
(*- fin -*)

(*- indice -*)
let indice (b,r)= (* nb : la fonction doit prendre un couple en entrée, et non deux argument entiers *)
    let x_bloc,y_bloc = b mod 3, b/3 in
        (3*x_bloc + r mod 3, 3*y_bloc +r/3)
;;
(*- fin -*)

(*- numeroBloc -*)
let numeroBloc (i,j)=
      3*(i/3) +(j/3)
;;
(*- fin -*)
 
 



(* --------------------------------------------------------------*)
(*----------------- règles du jeu -------------------------------*)
(*---------------------------------------------------------------*)


type litteral= X of int*int*int |NonX of int*int*int;;
(* X(i,j,k) signifie "la case i,j contient k" *)
type clause = litteral list;;
(* [X1; X2;X3] signifie "X1 ou X2 ou X3" *)
type formule=clause list;;
(* [c1;c2;c3] signifie "c1 et c2 et c3" *) 

(*- case 1 -*)
let case1()=
  (* crée la formule (K1) *)
  let res= ref [] in
  for i=0 to 8 do
    for j=0 to 8 do
      let c=ref[] in
      for k=1 to 9 do
        c:= X(i,j,k):: !c
      done;
      res:= !c:: !res
    done
  done;
  (!res:formule)
;;

(* Version purement récursive *)
let case1 ()=
  let rec aux i j k=
    if k=0 then []
    else X(i,j,k)::(aux i j (k-1))
  in
  let rec boucle i j =
    (* lance aux i j 9 pour tout i,j dans [|0,8|] *)
    if i=9 then
      begin
        if j=8 then []
        else
          boucle 0 (j+1)
      end
    else
      aux i j 9 :: (boucle (i+1) j )
  in
  boucle 0 0 ;;
case1();;
List.length (case1());;
(*- fin -*)


(* version fonctionnelle *)
let mapn f lists =
  List.map f
    (List.fold_left
       (fun indices_list liste -> (* Renvoie la liste de toutes les listes formées d'un élément de indices_list @ [un élément de liste] *)
         List.fold_right
           (fun indices l -> (List.map (fun indice -> indices@[indice]) liste) @ l)
           indices_list
           []
       )
       [[]]
       lists
    )
;;
let rec range a b = if b < a then [] else range a (b-1)@[b] ;;

let case1 _ =
  let _literal k i j = X(i, j, k) in
  let _clause [i;j] = List.map (fun k -> _literal k i j) (range 1 9) in
  let _formule = mapn _clause [(range 0 8);(range 0 8)] in
  _formule;;
List.length (case1 ());;

List.iter2
  (fun i j -> Printf.printf "%i%i " i j)
  (range 0 3)
  (range 0 3)
;;

let ligne1()=
  (* crée la formule (L1) *)
  let res= ref [] in
  for i=0 to 8 do
    for k=1 to 9 do
      let c=ref[] in
      for j=0 to 8 do
        c:= X(i,j,k):: !c
      done;
      res:= !c:: !res
    done
  done;
  (!res:formule)
;;

 let colonne1()=
    (* crée la formule (C1) *)
    let res= ref [] in
    for j=0 to 8 do
        for k=1 to 9 do
            let c=ref[] in
                for i=0 to 8 do
                    c:= X(i,j,k):: !c
                done;
                res:= !c:: !res
        done
    done;
    (!res:formule)
;;
(*- bloc1 -*)
let bloc1()=
  (* Crée la formule (B1) *)
    let res= ref [] in
    for b=0 to 8 do
        for k=1 to 9 do
            let c=ref[] in
                for r=0 to 8 do
                    let i,j=indice(b,r) in
                    c:= X(i,j,k):: !c
                done;
                res:= !c:: !res
        done
    done;
    (!res:formule)
;;
(*- fin -*)

(*- case2 -*)
let case2()=
    (* Crée la formule (K2) : toute case a au plus un chiffre*)
    let res=ref[] in
    for i =0 to 8 do
        for j=0 to 8 do
            for k=1 to 9 do
                for l=k+1 to 9 do
                        res:= [ NonX(i,j,k); NonX(i,j,l)]:: !res
                done
            done
        done
    done;
    !res
;;
(*- fin -*)

(*- ligne2 -*)
let ligne2()=
     (* Crée la formule (L2) : toute ligne a au plus un chiffre*)
    let res=ref[] in
    for i =0 to 8 do
        for k=1 to 9 do
            for j1=0 to 8 do
                for j2=j1+1 to 8 do
                        res:= [ NonX(i,j1,k); NonX(i,j2,k)]:: !res
                done
            done
        done
    done;
    !res
;;   
(*- fin -*)

let colonne2()=
     (* Crée la formule (C2) : toute ligne a au plus un chiffre*)
    let res=ref[] in
    for j =0 to 8 do
        for k=1 to 9 do
            for i1=0 to 8 do
                for i2=i1+1 to 8 do
                        res:= [ NonX(i1,j,k); NonX(i2,j,k)]:: !res
                done
            done
        done
    done;
    !res
;;

let bloc2()=
     (* Crée la formule (B2) : toute ligne a au plus un chiffre*)
    let res=ref[] in
    for b =0 to 8 do
        for k=1 to 9 do
            for r1=0 to 8 do
                for r2=r1+1 to 8 do
                        let (i1,j1)=indice (b,r1) and (i2,j2)=indice (b,r2) in
                        res:= [ NonX(i1,j1,k); NonX(i2,j2,k)]:: !res
                done
            done
        done
    done;
    !res
;;


(*
let regle = case1() @ ligne1() @ colonne1() @ bloc1() @ case2() @ ligne2() @ colonne2() @ bloc2();;
*)
(*list_length regle;;*)


 (* --------------------------------------------------------------*)
 (*----------------- lecture de la grille ------------------------*)
 (*---------------------------------------------------------------*)
 
 
let grilleExemple=[|
[|0;9;0;2;0;0;6;0;5|];
[|3;2;0;0;0;7;0;0;0|];
[|0;7;0;9;0;5;0;0;8|];
[|0;1;0;0;0;0;0;0;0|];
[|0;0;7;0;0;0;0;9;4|];
[|6;0;0;0;0;0;0;0;0|];
[|0;0;8;0;0;0;0;0;7|];
[|0;3;0;4;9;1;5;0;0|];
[|0;0;0;0;0;3;0;0;0|] |];;

(*- donnees -*)
let donnees g=
    (* Lit les cases déjà remplies de la grille g.
     Renvoie la liste de clauses isolées contenant pour chaque case (i,j) contenantt une valeur k, [X(i,j,k)]  et [NonX(i,j,l)] pour l≠k *)
    let res= ref [] in
    for i=0 to 8 do
        for j=0 to 8 do
            if g.(i).(j)<>0 then
                for k =1 to 9 do
                    if g.(i).(j)=k then
                        res:=  [X(i,j,k)] :: !res
                    else
                        res:=   [NonX(i,j,k)] :: !res
                done
        done
    done;
    !res
;;
(*- fin -*)

(*- interdites_ij -*)
let interdites_ij g (i,j)=
    (* Renvoie la formule (formée de clause unitaires négatives) indiquant les chiffres impossibles en case (i,j), après utilisation directe des règles B2, L2, et K2. *)
    
    let res= ref [] in
    
    (* lecture de la ligne i *)
    for j'=0 to 8 do
         if j' <> j && g.(i).(j') <>0 then  res:= ajout [NonX(i,j',g.(i).(j'))]  !res
    done;
    
    (* lecture de la colone j*)
    for i'=0 to 8 do
         if i' <> i && g.(i').(j) <>0 then  res:= ajout [NonX(i',j,g.(i').(j))] !res
    done;

    (* lecture du bloc*)
    let b = numeroBloc (i,j) in
    for r=0 to 8 do
        let (i',j') = indice (b,r) in
         if (i,j) <> (i',j') && g.(i').(j') <>0 then  res:= ajout [NonX(i',j',g.(i').(j'))]  !res
    done;
    
    !res
;;
(*- fin -*)

(*- interdite -*)
let interdites g=
    let res = ref[] in
    for i=0 to 8 do
        for j=0 to 8 do
            if g.(i).(j) =0 then
                res:= interdites_ij g (i,j) @ !res (* il ne peut pas y avoir de doublons entre ces deux listes *)
        done
    done;
    !res
;;
(*- fin -*)

(* Pour chaque case de la grille, F_{grille} contient au plus 9 clauses :
    - si elle est remplie, il y a exactement 9 clauses (clauses unitaire, 1 pour le chiffre possible et 8 pour les chiffres impossibles)
    - si elle n'est pas remplie, il y a au plus 8 clauses qui indiquent des valeurs impossibles. Ceci car dans la fonction interdite_ij on a pris soin d'utiliser la fonction ajoute qui évite les doublons.

Au total, il y a au plus 9*9*9, càd 727 clauses dans F_{grille}.
    *)



let formule_initiale g=
    case1() @ ligne1() @ colonne1() @ bloc1() @ case2() @ ligne2() @ colonne2() @ bloc2() @ donnees g @ interdites g
    ;;


let f_exemple = formule_initiale grilleExemple;;
  
  
    
 (* --------------------------------------------------------------*)
 (*----------------- propagation unitaire ------------------------*)
 (*---------------------------------------------------------------*)

(*- nv lit_isole -*)
let rec nouveau_lit_isole f=
    (* Renvoie un littéral isolé dans f. Renvoie X(-1,-1,-1) s'il n'y en a pas.*)
    match f with
        |[]         -> X(-1,-1,-1)
        |[l] :: _   -> l
        |_::q       -> nouveau_lit_isole q
;;
(* O(n) *)
(*- fin -*)
nouveau_lit_isole (formule_initiale grilleExemple);;
 
(*- simplification -*)
let non = function
    | X(i,j,k)      -> NonX(i,j,k)
    |NonX(i,j,k)    -> X(i,j,k)
;;
 
let rec simplification l f=
    (* l est un litéral isolé. Donc toute valuation qui satisfait f doit satisfaire l.
     À partir de là, elle satisfait toute clause contenant l, qui devient donc inutile.
     Et de plus, toute clause contenant non l ne peut être satisfaite via ce non l, on peut donc enlever ce littéral.
     *)
     match f with
        |[]     ->[]
        |clause :: q  when appartient l clause  -> simplification l q
        |clause :: q        -> (supprime (non l) clause) :: simplification l q
;;
(*- fin -*)

(*- propagation -*)
let rec propagation g f =
    let l = nouveau_lit_isole f in
        match l with
            |X(-1,-1,-1)    ->  f
            |X(i,j,k)       ->   g.(i).(j) <- k;
                                 propagation g (simplification l f)
            |NonX(i,j,k)    ->  propagation g (simplification l f)
;;


(* Version avec affichage pour suivre la résolution en direct *)
open Printf;;
let rec propagation ?(dec = "") g f =
  (* dec (argument facultatif, valeur par défaut "") décale les affichages. Utilisé dans la suite pour les essais lors de la résolution. *)
    let l = nouveau_lit_isole f in
        match l with
            |X(-1,-1,-1)    -> printf "%s -- propagation unitaire finie.\n" dec;  f
            |X(i,j,k)       -> printf "%s je mets %i case %i \n%!" dec k (10*i+j);
                                 g.(i).(j) <- k;
                                 propagation g (simplification l f)
            |NonX(i,j,k)    ->  propagation g (simplification l f)
;;
(*- fin -*)

let test ?(x = 1) y = x+y;;

let affiche grille=
    print_newline ();
     List.iter (fun ligne -> List.iter (fun i-> print_int i; print_string " ") ligne; print_newline ()) grille;;
 

let affiche_ligne l=
    print_string "|";
    for i=0 to 2 do
        for k=0 to 2 do
            print_int l.(3*i+k)
        done;
        print_string "|"
    done;
    print_newline()
;;

let trait_horizontal ()=
     List.iter (fun _-> print_string "-") [0;1;2;3;4;5;6;7;8;9;10;11;12];
     print_newline()
;;

let affiche grille=
    trait_horizontal ();
    for i=0 to 2 do
        for k=0 to 2 do
            affiche_ligne grille.(3*i+k)
        done;
        trait_horizontal ()
    done
;;


let meth1 grille=
    let f= propagation grille (formule_initiale grille) in
    affiche grille;f 
    ;;
 

meth1 grilleExemple;; 
 
 

 
 (* --------------------------------------------------------------*)
 (*----------------- litéral infructueux -------------------------*)
 (*---------------------------------------------------------------*)
 
 
 let rec concatSansDoublon l1 = function
    | []    -> l1
    | t::q  -> ajout t (concatSansDoublon l1 q)
 ;;
 
 concatSansDoublon [1;3;4;2;7] [2;4;5;7;9];;
 

 
 (*- variables -*)
 let rec variablesDansClause = function
    (* Renvoie la liste des variables utilisées dans une clause, sans doublon.*)
    | []    -> []
    |X(i,j,k)::q       -> ajout (X(i,j,k)) (variablesDansClause q)
    |NonX(i,j,k)::q    -> ajout (X(i,j,k)) (variablesDansClause q)
;;
 
let variables (f:formule)=
   List.fold_left
     concatSansDoublon
     []
     (List.map variablesDansClause f)
;;
(*- fin -*)

(*- deduction -*)
let copie_matrice m=
     let n,p=(Array.length m), (Array.length m.(0)) in
     let res = Array.make_matrix n p 0 in
     for i=0 to n-1 do
        for j=0 to p-1 do
            res.(i).(j) <- m.(i).(j)
        done
    done;
    res;;


(* Encore un peu d'affichage... Ne vous préoccupez pas des deux fonctions ci-dessous ni des printf dans la suite.*)
let litt_to_string = function
  | X(i,j,k)  ->  string_of_int k ^" en case "^string_of_int (10*i+j)
  | NonX(i,j,k)  ->"pas "^ string_of_int k ^" en case "^string_of_int (10*i+j)
;;

let affiche_litt _ = function
  | X(i,j,k)  -> printf "%i en case %i" k (10*i+j)
  | NonX(i,j,k)  -> printf "pas %i en case %i" k (10*i+j)
;;

let deduction g x f =
  (* Renvoie 1 s'il est impossible que non x, -1 s'il est impossible que x, et 0 si la méthode utilisée ne permet par de conclure.*)
    let gc = copie_matrice g in
    (* Comme la fonction propagation modifie la grille fournie, nous lui fournissons uniquement une copie.*)
    if (
      printf "J'essaie %a " affiche_litt x;
      appartient [] (propagation ~dec:"   " gc ([x]::f))

    )then (
      printf "absurde!";
      -1
    )
    else if (
      printf "J'essaie %a " affiche_litt (non x);
      appartient [] (propagation ~dec:"   " gc ([non x]::f))
    )then (
      printf "absurde !";
      1
    )
    else 0
;;
(*- fin -*)

(*- propagation2 -*)
let rec propagation2 g f=
    let f1 = propagation g f in
    
    let rec parcourtVariables=function
        (* Cette fonction auxiliaire est chargée de parcourir les variables de f1 pour voir s'il y a une déduction à faire.*)
        |[]     -> () (*Plus aucune déduction possible, fin de l'algo*)
        |x::q   -> 
            begin
            match deduction g x f1 with
                | 0     -> parcourtVariables q
                | 1     ->  printf "déduction : %a \n" affiche_litt x;
                             propagation2 g ([x]::f1)
                | -1    ->  printf "déduction : %a\n " affiche_litt (non x);
                            propagation2 g ([non x]::f1)
                | _     -> failwith "résultat de déduction non valide"
            end
    in
    
    parcourtVariables (variables f1)
;;

let meth2 grille=
    propagation2 grille (formule_initiale grille);
    affiche grille
    ;;
 (*- fin -*)

meth2 grilleExemple;; 

        
