#! /usr/bin/python3
# -*- coding: utf-8 -*-

### fusionEntre ###
def fusionEntre(t, deb, m, fin):
    """ Fusionne en place t[deb:m] et t[m:fin], qui doivent être triés au préalable."""
    temp=[]# Contiendra la fusion de t[deb:m] et t[m:fin]
    i, j = deb, m

    while i < m and j < fin :
        # Imvariant de boucle : temp contient la fusion de t[deb:i] et t[m:j]
        if t[i] < t[j]:
            temp.append(t[i])
            i+=1
        else:
            temp.append(t[j])
            j+=1

    temp.extend(t[i:m])
    # Les éléments de t[j:fin] sont déjà dans leur place finale : inutile de les mettre dans temp pour les remettre ensuite dans t

    # On recopie temp dans t:
    for k in range(len(temp)):
        t[deb+k]=temp[k]
### fin ###

# Optimisation de la mémoire utilsée : au lieu de créer un tableau externe de taille fin-deb, je vais juste sauvegarder t[deb:m].
### opti_mémoire ###
def fusionEntre(t, deb, m, fin):
    morceau1 = t[deb:m] # NB : avec des tableaux numpy ceci ne marcherait pas car ne créeait pas une copie
    n1 = m-deb # nb d'éléments dans le premier morceau
    i, j = 0, m # i indique le prochain morceau à prendre dans morceau1, j le prochain élément à prendre dans t
    k=deb # emplacement où écrire le prochain élément dans t
    while i < n1 and j < fin :
        if morceau1[i] < t[j]:
            t[k] = morceau1[i]
            i+=1
        else:
            t[k] = t[j]
            j+=1
        k+=1

    # On met les éléments restant dans morceau1
    while i < n1:
        t[k] = morceau1[i]
        i+=1
        k+=1
### fin ###



### Optimisation : on isole le début de t[deb:m] et la fin de t[m:fin] qui n'ont pas besoin de bouger.

### fusion_opti ###
# ATTENTION : fin est inclu, c'est perturbant en Python !
def cherchePlaceGauche(t, deb, fin, x):
    """ Renvoie un indice i où insérer x dans t[deb:fin] afin de conserver le caractère trié de cette tranche de tableau.
    Précisément, on aura : t[i-1] <= x < t[i] 
                        et    deb <= i <= fin
    Rema : dans le cas où plusieurs places sont possibles, je renvoie la plus à droite, vu la place de l'inégalité large ci-dessus.
    """
    if deb==fin:
        return deb
    else:
        m=(deb+fin)//2 # Au pire, m==deb
        if x<t[m]:
            return cherchePlaceGauche(t, deb, m, x)
        else:#x >= t[m]
            return cherchePlaceGauche(t, m+1, fin, x)

# version impérative. Ecrire l'invariant de boucle!
def cherchePlaceGauche(t, deb, fin, x):
    """ Renvoie i tel que :  t[i-1] <= x < t[i] 
                        et      deb <= i <= fin
    """
    d, f = deb, fin
    while d < f:
        # Invariant : t[d-1] <= x < t[f]
        m=(d+f)//2
        if x<t[m]:
            f=m
        else: # t[m] <= x
            d=m+1
    # sortie de boucle : d==f, et vu l'invariant ce nombre est le bon résultat.
    return d



def cherchePlaceDroite(t, deb, fin, x):
    """
    Renvoie i€[deb,fin] tel que t[i] < x <= t[i+1]
    """
    if deb==fin:
        return deb
    else:
        m=(deb+fin+1)//2 # Au pire, m==fin
        if x<=t[m]:
            return cherchePlaceDroite(t, deb, m-1, x)
        else:#x > t[m]
            return cherchePlaceDroite(t, m, fin, x)


def fusionEntreOpti(t, deb, m, fin, debug=False):
    assert deb <= m <= fin
    a= cherchePlaceGauche(t, deb, m, t[m])
    b= cherchePlaceDroite(t, m-1, fin-1, t[m-1])
    if debug:
        print(t[m], "sera mis case ", a)
        print("et", t[m-1], "sera mis case ", b)
    fusionEntre(t, a
                 , m
                 , b+1 # Attention ici
                 )
### fin ###


### prochainePlage ###
def prochainePlage(t,deb):
    """ Renvoie i maximal tel que t[deb:i] est trié dans l'ordre croissant."""

    res=deb+1
    n=len(t)
    while res < n and t[res-1]<=t[res]:
        res+=1
        # Ici, t[deb:res] est trié
    return res
### fin ###
ttest=[1,2,3,0,8,12]

### écrae ###
# Je vais la faire récursive
def écrase(t, àFusionner):
    if len(àFusionner)==1:
        None #Cas d'arrêt
    else:
        (d0, f0) = àFusionner.pop()
        (d1, f1) = àFusionner.pop()
        # rema : on doit avoir f1==d0
        if 2*(f0-d0) > f1-d1 :
            fusionEntreOpti(t, d1, f1, f0)
            àFusionner.append( (d1, f0) )
            écrase(t, àFusionner)
        else:
            # Sinon : cas d'arrêt, l'invariant de boucle est vérifié.Remettre la pile en état
            àFusionner.append( (d1,f1) )
            àFusionner.append( (d0,f0) )
### fin ###

### fusionne_tout ###
def fusionne_tout(t, àFusionner):
    while len(àFusionner) >1:
        (d0, f0) = àFusionner.pop()
        (d1, f1) = àFusionner.pop()
        fusionEntreOpti(t, d1, f1, f0)
        àFusionner.append( (d1, f0) )
### fin ###        

### timsort0 ###
def timsort0(t, debug=False):
    n=len(t)
    i=0
    àFusionner=[]

    while i <n:
        if debug : print(àFusionner, t)
        fin = prochainePlage(t,i)
        àFusionner.append( (i,fin) )
        écrase(t, àFusionner)
        i=fin

    fusionne_tout(t, àFusionner)
    #Maintenant, àFusionner contient un seul élément : (0,n). Donc t[0:n], càd t, est trié.
### fin ###


    
ttest=[5,4,7,4,1,0,6,9,8,7]




###############  en récupérant aussi les plages décroissantes #########################

def retourne(t, deb, fin):
    """ Renverse l'ordre des éléments de t[deb:fin] en temps linéaire. """
    for i in range(0, (fin-deb)//2):
        t[deb+i], t[fin-1-i] = t[fin-1-i], t[deb+i]


def prochainePlage2(t,deb, debug=False):
    """ Renvoie i maximal tel que t[deb:i] est trié dans l'ordre croissant ou décroissant. Dans le cas décroissant, renet de plus la plage t[deb:i] à l'endroit."""

    res=deb+1
    n=len(t)
    if n==res : return res
    else:
        # Va-t-on chercher un morceau croissant ou décroissant ?
        croissant= t[deb]<=t[deb+1]
        # Création de la relation d'ordre idoine :
        if croissant :
            ordre = lambda x,y : x<=y
        else:
            ordre=lambda x,y : x >=y
            
        while res < n and ordre (t[res-1], t[res]):
            res+=1
            # Ici, t[deb:res] est trié selon ordre
        if not croissant : retourne(t,deb,res)
        if debug : print(t, deb, res, croissant)
        return res



def timsort2(t, debug=False):
    n=len(t)
    i=0
    àFusionner=[]

    while i <n:
        if debug : print(àFusionner, t )
        fin = prochainePlage2(t,i, debug=debug)
        àFusionner.append( (i,fin) )
        écraseOpti(t, àFusionner)
        i=fin

    fusionne_tout_opti(t, àFusionner)


    
######## Version 4 : insertion pour les petits nombres d'éléments ############

LONGUEUR_MIN=6 # La coutume est de mettre les variables globales en majuscule

def insere(t, deb, i, ordre):
    """ Entrées : un tableau t
                  deux indices deb et i
                  une relation d'ordre ordre
        Précondition : t[deb:i] est trié selon ordre
        Effet : insère t[i] dans t[deb:i] de sorte que t[deb:i+1] devienne trié, toujours selon ordre.
        """
    x=t[i]
    k=i #place finale de x
    while not ordre(t[k-1], x)  and k>=deb :
        t[k]=t[k-1]
        k-=1
    t[k]=x

def prochainePlage3(t,deb, debug=False):
    """ À l'issue de cette fonction-procédure, en notant res l'indice renvoyé, t[deb:res] est trié dans l'ordre croissant, et contient au moins LONGUEUR_MIN éléments. En outre, t[deb:res] n'est pas trié."""

    res=deb+1
    n=len(t)
    if n==res : return res
    else:
        croissant= t[deb]<=t[deb+1]
        if croissant :
            ordre = lambda x,y : x<=y
        else:
            ordre=lambda x,y : x >=y

            
        while res < n and (ordre (t[res-1], t[res]) or res-deb < LONGUEUR_MIN):
            insere(t,deb,res,ordre) # nb : Si t[i] était déja en place, insere effectue une seule comparaison. On ne gaspille donc qu'une comparaison à lancer insere dans tous les cas.
            res+=1
            # Ici, t[deb:res] est trié selon ordre
        if not croissant : retourne(t,deb,res)
        if debug : print(t, deb, res, croissant)
        return res


def timsort3(t, debug=False):
    n=len(t)
    i=0
    àFusionner=[]

    while i <n:
        if debug : print(àFusionner, t )
        fin = prochainePlage3(t,i, debug=debug)
        àFusionner.append( (i,fin) )
        écraseOpti(t, àFusionner)
        i=fin

    fusionne_tout_opti(t, àFusionner)


# Sans l'amélioration 2 qui semble contre-productive sur les premiers tests
def timsort4(t, debug=False):
    n=len(t)
    i=0
    àFusionner=[]

    while i <n:
        if debug : print(àFusionner, t )
        fin = prochainePlage3(t,i, debug=debug)
        àFusionner.append( (i,fin) )
        écrase(t, àFusionner)
        i=fin

    fusionne_tout(t, àFusionner)
# On constate que c'est moins efficace !



# test
import os



