#directory "/home/moi/enseignement/Informatique/bibs";; (* Rajouter ce répertoire aux répertoires dans lesquels Caml va chercher pour les #use *)
(* Dans mon dossier « bibs » j'ai les trois fichiers suivants, qui implémentent respectivement des files d'attentes persistantes, le tri fusion, et les tas-max persistants . *)
#use "files.ml";;
#use "tris.ml";; (* Permet de charger fusion *)
#use "tas_persistants.ml";; (* Il s'agit de tas max *)


(*- prochain_morceau -*)
let rec prochain_morceau l =

  let rec aux prec = function
    (* Argument supplémentaire : prec le dernier élément pris dans le morceau actuel *)
    (* Renvoie un couple (éléments dans l'ordre et >= prec au début de la liste, suite de la liste)  *)
    |[]  ->[], []
    |t::q when prec <= t ->
       let morceau, suite = aux t q in t::morceau, suite
    |t::q  ->
       [], t::q
  in

  match l with
  |[]->[],[]
  |t::q-> let m, s = aux t q in t::m, s
;;
(*- fin -*)

(* liste_decouped -*)
(* Pas besoin d'accu ici ! Comme d'habitude, l'usage ou non d'un accu change l'ordre dans lequel le résultat sera enregistré, mais à ce stade l'ordre n'est pas important.*)
let rec liste_decouped = function
    |[] -> fileVide
    |l -> let morceau, suite = prochain_morceau l in
	     enfiled morceau (liste_decouped suite)
;;
(*- fin -*)
liste_decouped [1;2;0;-1;3;4];;


(*- tri1 -*)
let tri1 l=

  let rec rassemble f=
  (* f : file d'attente des sous-listes à fusionner *)
    match defiled f with
    |t, q when q=fileVide -> (* une seule liste dans la file : cas d'arrêt*) t
    |t, q  -> let s, q2 = defiled q in
	      rassemble (enfiled (fusion s t) q2)
  in
  
  rassemble (liste_decouped l )
;;
(*- fin -*)
tri1 [4;6;7;3;2;1;8;9];;

(*- fold_file -*)
(* Cette première version n’effectue en fait pas les opération dans l’ordre voulu *)
let rec fold_file op e file =
  (* op : opération à appliquer aux éléments de la file.
      e : élément de départ (souvent le neutre) *)
  if file=fileVide then e
  else
    let x, suite = defiled file in
    op x (fold_file op e suite)
;;

(* Cette version réenfile les résultas intermédiaires afin d'effectuer les opérations dans l'ordre voulu ici.*)
let rec fold_file op e file =
  (* op : opération à appliquer aux éléments de la file.
      e : élément de départ (souvent le neutre) *)
  if file=fileVide then e
  else
    let x, suite = defiled file in
    if suite=fileVide then x
    else let y, ssuite = defiled suite in
      fold_file op e (enfiled (op x y) ssuite)
;;
(*- fin -*)



(*- tri_fonctionnel -*)
let tri_f l=
  fold_file
    fusion
    []
    (liste_decouped l)
;;
(*- fin -*)

tri_f [0;6;59;8];;


(* Amélioration 2 *)
(* Je récupère aussi les sous-listes décroissantes, lesquelles seront retournées avant d'être mise dans la file *)

(*- decr -*)
let rec aLenvers l=
  let rec aux accu = function
    |[] -> accu
    |t::q -> aux (t::accu) q
  in
  aux [] l;;

aLenvers [1;2;3];;


let prochain_morceau l =
  (* Renvoie le couple (préfixe monotone de l retourné s'il était décroissant, suite de l) *)

  let rec aux prec croissant = function
  (* arg supplémentaire : prec élément précédent
                          croissant : booléen qui indique si on extrait une sous-suite croissante*)
    |[] -> [], []
    |t::q when (t>=prec && croissant) || (t<= prec && not croissant) -> (* On continue *)
       let morceau, suite = aux t croissant q in
       t::morceau, suite
    |t::q  -> (* fini *)
       [], t::q
  in

  match l with
  |[] -> [], []
  |[t] -> [t], []
  |s::t::q when s<= t -> (* On cherche un morceau croissant *)
     let morceau, suite = aux t true q in (s::t::morceau, suite)
				       
  |s::t::q -> (* On cherche un morceau décroissant. Le retourner avant de le mettre dans la file !  *)
     let morceau, suite = aux t false q in (aLenvers (s::t::morceau), suite)
;;
(*- fin -*)
prochain_morceau [0;1;3;2;1;4;6];;

(* On garde alors decoupe_liste et tri comme avant *)


(* -------------------------------------------------------------------------- *)
(* ------------------------ Amélioration 3 ---------------------------------  *)
(* -------------------------------------------------------------------------- *)


(* On fixe une taille minimale pour les morceaux, on complète au moyen de la fonction insertion si besoin. *)


(*- insertion -*)
let taille_min = 6;;


let rec insertion x croissant = function
  (* croissant est un booléen qui indique si on insère dans une suite croissante. Dans le cas contraire, on insère dans une suite décroissante.*)
  |[] -> [x]
  |t::q when (x<= t && croissant) || (x>=t && not croissant) -> x::t::q
  |t::q -> t:: (insertion x croissant q)
;;




let prochain_morceau l =
  (* Renvoie le couple (préfixe monotone de l retourné s'il était décroissant, suite de l) *)

  let rec aux prec croissant taille accu = function
    (* arg supplémentaire : prec : élément précédent
                            croissant : booléen qui indique si on extrait une sous-suite croissante
                            taille : nb d'éléments déjà pris
     Le morceau renvoyé est dans l'ordre not croissant *)
    |[] -> (accu  , [])
      
    |t::q when (t>=prec && croissant) || (t<= prec && not croissant) -> (* On continue *)
        aux t croissant (taille +1) (t::accu) q
	 
    |t::q  -> (* fin du morceau monotone *)
       if taille < taille_min then
         (* On rajoute un élément par insertion *)
	 (* Attention : il faut garder prec dans l'appel récursif, car t va être mis au milieu de la liste *)
	 aux prec croissant (taille+1) (insertion t (not croissant) accu) q
       else
	 (accu, t::q)
  in

  
  match l with
  |[] -> [], []
  |[t] -> [t], []
  |s::t::q when s<= t -> (* On cherche un morceau croissant *)
     let morceau, suite = aux t true 2  [ t; s] q in (aLenvers morceau, suite)
					 
  |s::t::q -> (* On cherche un morceau décroissant *)
     let morceau, suite = aux t false 2 [s;t] q in ( morceau, suite)
;;

prochain_morceau [0;1;3;2;1;4;6;9;0;1];;
(*- fin -*)

(*- calcule_taille_min -*)
let calcule_taille_min n =
  (* Entrée : la longueur de la liste à trier
     Sortie : la taille optimale des morceaux. *)


  let rec bit_de_plus_grand_poids k =
    (* indice du bit de plus haut poids de k. (Bit des unités d'indice 0) *)
    if k=0 then -1
    else 1+ bit_de_plus_grand_poids (k/2)
  in

  let i = bit_de_plus_grand_poids n
  in n lsr (i-6)
     +
       (if n mod (1 lsl (i-7)) = 0 then 0 else 1)
;;
(*- fin -*)



(* -------------- dernière amélioration : utilisation d'une file de priorité -------------- *)


(*- tas -*)
(* On a besoin de la taille des morceaux, modifions très légèrement prochain_morceau pour qu'il la renvoie *)
let prochain_morceau4 l =
  (* Renvoie le triplet (préfixe monotone de l retourné s'il était décroissant, suite de l, taille du morceau) *)

  let rec aux prec croissant taille accu = function
    (* arg supplémentaire : prec : élément précédent
                            croissant : booléen qui indique si on extrait une sous-suite croissante
                            taille : nb d'éléments déjà pris
     Le morceau renvoyé est dans l'ordre not croissant *)
    |[] -> (accu  , [], taille)
      
    |t::q when (t>=prec && croissant) || (t<= prec && not croissant) -> (* On continue *)
        aux t croissant (taille +1) (t::accu) q
	 
    |t::q  -> (* fin du morceau monotone *)
       if taille < taille_min then
         (* On rajoute un élément par insertion *)
	 (* Attention : il faut garder prec dans l'appel récursif, car t va être mis au milieu de la liste *)
	 aux prec croissant (taille+1) (insertion t (not croissant) accu) q
       else
	 (accu, t::q, taille)
  in

  
  match l with
  |[] -> [], [], 0
  |[t] -> [t], [], 1
  |s::t::q when s<= t -> (* On cherche un morceau croissant *)
     let morceau, suite, taille = aux t true 2  [ t; s] q in (aLenvers morceau, suite, taille)
					 
  |s::t::q -> (* On cherche un morceau décroissant *)
     let morceau, suite, taille = aux t false 2 [s;t] q in ( morceau, suite, taille)
;;



(* J'entasse des couples (-taille, morceau trié), afin que les petits morceaux se retrouvent en haut du tas.
   C'est juste une astuce pour pouvoir utiliser des tas-max là où un tas-min serait plus pertinent. *)

let rec decoupe_liste2 = function
    |[] -> Vide
    |l -> let morceau, suite, taille = prochain_morceau4 l in
	     entasse (-taille, morceau) (decoupe_liste2 suite)
;;
(*- fin -*)

(*- tri4 -*)
let tri4 l=

  let rec rassemble f=
  (* f : file de priorité des sous-listes à fusionner *)
    match extraitMax f with
    |(taille, l), Vide -> (* une seule liste dans la file : cas d'arrêt*) l
    |(taille1, l1), q  -> let (taille2, l2), q2 = extraitMax q in
	      rassemble (entasse (taille1+taille2, fusion l1 l2) q2)
  in
  
  rassemble (decoupe_liste2 l )
;;
(*- fin -*)
tri4 [4;6;7;3;2;1;8;9];;

