## A faire:
  # lire les horaires des créneaux
  # Faire un vrai aléatoire. Itérateur aléatoire pour derniereColle ?


import numpy as np
import copy  #Pour copier une liste imbriquée en "désolidarisant" les deux copies
import datetime

from boiteAOutils import *
from bibCollo import * 
from contraintesSupp import *

#chemin=input("adresse du fichier de données")
chemin="/home/moi/Dropbox/PCSI/2016-2017/colloscope/donneesS1v4Plein.txt"





##lecture des données élémentaires
fichier=open(chemin,"r")
nbGroupes=int(fichier.readline().strip().split(":")[1])
print("nombre de groupes:", nbGroupes)
semaineDeDepart=int(fichier.readline().strip().split(":")[1])
print("semaine de départ:", semaineDeDepart)
semaineFinale=int(fichier.readline().strip().split(":")[1])
print("semaine finale:",semaineFinale)
uneSemaineA=int(fichier.readline().strip().split(":")[1])
premierJour=datetime.datetime( *tuple( map(int, (fichier.readline().strip().split(":")[1]).split(","))) )
print("premier jour : " + str(premierJour.day) +"/"+str(premierJour.month) )
fichier.readline()
ligneCourante=fichier.readline().split(",")
semainesSansColle = [0 for s in range(semaineFinale)]
for x in ligneCourante:
    semaine,nbTrou = x.split(":")
    semainesSansColle[int(semaine)-1]=int(nbTrou)
print("semaines sans colles :", semainesSansColle)
print("\n")




##lecture des contraintes
#creneauPossible[groupe][matiere][numCreneau] renvoie un booleen
print("lecture des contraintes")

fichier.readline()
fichier.readline()

#Impossibilités toutes semaines
#Note: tous les identifiants de contrainte doivent être utilisés dans le fichier de données dans la partie toutes semaines. Par exemple mettre ";Y;" si aucune contrainte pour Y.
#dictionnaireDesContraintes[idContrainte]= liste d'horaires
dictionnaireDesContraintes={}

ligneCourante=fichier.readline().strip()
while ligneCourante!="":
    ligneCourante=ligneCourante.split(":")
    dictionnaireDesContraintes[ligneCourante[1]]=[]
    if ligneCourante[2]!="":
        dictionnaireDesContraintes[ligneCourante[1]]= list( map(str_vers_horaire,  ligneCourante[2].split(",")))

    ligneCourante=fichier.readline().strip()
afficheDico(dictionnaireDesContraintes)
print('\n')


fichier.readline()
ligneCourante=fichier.readline().strip()
#impossibilités semaines A
dictionnaireDesContraintesSemainesA=copy.deepcopy(dictionnaireDesContraintes)
while ligneCourante!="":
    ligneCourante=ligneCourante.split(":")
    #dictionnaireDesContraintesSemainesA[ligneCourante[1]]=[]
    if ligneCourante[2]!="":
        concateDansDico( dictionnaireDesContraintesSemainesA, ligneCourante[1], list( map(str_vers_horaire,  ligneCourante[2].split(","))))

    ligneCourante=fichier.readline().strip()
#print("semaines A " , dictionnaireDesContraintesSemainesA)

fichier.readline()
ligneCourante=fichier.readline().strip()
#impossibilités semaines B
dictionnaireDesContraintesSemainesB=copy.deepcopy(dictionnaireDesContraintes)
while ligneCourante!="":
    ligneCourante=ligneCourante.split(":")
    #dictionnaireDesContraintesSemainesB[ligneCourante[1]]=[]
    if ligneCourante[2]!="":
        concateDansDico( dictionnaireDesContraintesSemainesB, ligneCourante[1], list( map(str_vers_horaire,  ligneCourante[2].split(","))))

    ligneCourante=fichier.readline().strip()
#print("semaines B " , dictionnaireDesContraintesSemainesB)

#conversion en semaine paire/ impaire
if uneSemaineA % 2 == 0: # les semaines paires (pour l'utilisateur) sont A
    dictionnaireDesContraintesSemainesPaires=dictionnaireDesContraintesSemainesA
    dictionnaireDesContraintesSemainesImpaires=dictionnaireDesContraintesSemainesB
else:
    dictionnaireDesContraintesSemainesPaires=dictionnaireDesContraintesSemainesB
    dictionnaireDesContraintesSemainesImpaires=dictionnaireDesContraintesSemainesA

fichier.readline()


"""
#Lecture des incompatibilités:
#incompatibilites est une liste de listes de créneaux incompatibles. Un créneau est une liste de deux entiers [numMatiere, numCreneau]
ligneCourante=fichier.readline().rstrip("\r\n")
incompatibilites=[]
while ligneCourante!="":
    ligneCourante=ligneCourante.split(",")
    incompatibiliteCourante=  [ [ dictionnaireMatieres[m[0]], int(m[1])-1 ] for m in ligneCourante]
    incompatibilites.append(incompatibiliteCourante)
    ligneCourante=fichier.readline().rstrip("\r\n")

fichier.readline()
"""

# Lecture des créneaux
# exemple : descriptionCreneaux['M'][0] = [('mardi',18),'Charignon','H109']
descriptionCreneaux={}
ligneCourante=fichier.readline().strip()
while ligneCourante!="":
    creneau=ligneCourante.split(",")
    ajouteDansDico([ str_vers_horaire(creneau[1]),  creneau[2],creneau[3]  ],descriptionCreneaux,creneau[0])
    ligneCourante=fichier.readline().strip()
#afficheDico(descriptionCreneaux)



listeDesMatieres=list(descriptionCreneaux.keys())
nbMatieres=len(listeDesMatieres)
dictionnaireMatieres={ listeDesMatieres[i] : i   for i in range(nbMatieres)}#Pour récupérer le numéro de la matière  partir de sa lettre. (Opération réciproque de listeDesMatieres)
# note : Ca serait plus sympa de garder partout la lettre...
nbCreneaux= { mat : len(descriptionCreneaux[mat]) for mat in listeDesMatieres}





def calculDesCouplesDeCreneauxPossible():
    print("calcul des incompatibilités")
    #couplesCreneauxPossiblesBool[mat1][mat2][num1][num2] =  un booléen
    couplesCreneauxPossiblesBool={}
    for mat1 in listeDesMatieres:
        couplesCreneauxPossiblesBool[mat1]={}
        for mat2 in listeDesMatieres:
            couplesCreneauxPossiblesBool[mat1][mat2]=[]
            for num1 in range( nbCreneaux[mat1]):
                couplesCreneauxPossiblesBool[mat1][mat2].append([])
                for num2 in range( nbCreneaux[mat2]):
                    couplesCreneauxPossiblesBool[mat1][mat2][num1].append( descriptionCreneaux[mat1][num1][0]!=descriptionCreneaux[mat2][num2][0])
    return couplesCreneauxPossiblesBool

couplesCreneauxPossiblesBool=calculDesCouplesDeCreneauxPossible()

####### Tableau des matières voulues

fichier.readline()
ligneCourante=fichier.readline().rstrip("\r\n")

couplesDeMatieres=[]#Cette liste va contenir tous les couples de matière qui doivent intervenir. Utilisé pour calculer les couples de créneaux possibles

#creation du tableau vide:
matiereVoulue=[]
for s in range(semaineFinale):
    matiereVoulue.append([])
    for g in range(nbGroupes):
        matiereVoulue[s].append([])

while ligneCourante!="":#éventuellement plusieurs lignes: si tous les groupes n'ont pas les mêmes matières (ex: PCSI second semestre. Ou différentes LV1.)

    ligneCourante=ligneCourante.split(":")
    gpesConcernes=list(map(int, ligneCourante[0].split(",")))
    suiteMatiereVoulue=[  (m[0], m[1])  for m in ligneCourante[1].split(";")]
    
    #rajouter les couples de matières qui interviennent:
    for c in suiteMatiereVoulue:
        if not(c in couplesDeMatieres):
            couplesDeMatieres.append(c)
    
    n=len(suiteMatiereVoulue)
    #par exemple matiereVoulue[semaine][groupe][numColle] = 'M'. (NumColle=0 ou 1.)
    for s in range(semaineFinale):
        for g in gpesConcernes:
            matiereVoulue[s][g-1]=suiteMatiereVoulue[(s+g)%n] 
    ligneCourante=fichier.readline().strip()



def matieresRicRac():
    """Renvoi un dictionnaire indiquant pour chaque semaine, les matières qui n'ont aucun créneau de marge.
    En outre, affiche un message d'avertissement pour les matières qui n'ont pas assez de créneaux"""
    res={}
    for s in range(semaineDeDepart-1, semaineFinale):
        l=[]
        for matiere in listeDesMatieres:
            compte=0
            for g in range(nbGroupes):
                if matiereVoulue[s][g][0] == matiere or matiereVoulue[s][g][1] == matiere : compte+=1
            if compte== nbCreneaux[matiere]: l.append(matiere)
            if compte > nbCreneaux[matiere]: print('pas assez de créneaux pour ',matiere,' semaine ',s+1)
        res[s+1] = l
    return(res)


def afficheMatieresVoulues():
    """affiche le tableau des matières voulues.
    Pour chaque créneau: une case pour la lettre, deux cases pour le numéro."""
    ricRac= matieresRicRac()
    for s in range(semaineDeDepart-1, semaineFinale):

        #affichage de la semaine
        ligne ="s"+str(s+1)
        if s<9:
            ligne+=" :"
        else:
            ligne+=":"
            
        for g in range(nbGroupes):
            ligne+=  matiereVoulue[s][g][0] +"  "+  matiereVoulue[s][g][1] + "   | "
        ligne+= str(ricRac[s+1])
        print(ligne)


fichier.readline()


##lecture des professeurs de la classe
#Dans le but de voir si chaque professeur de la classe pourra voir chaque élève
#profsDeLaClasse[matiere] contient la liste des créneaux qu'à la prof de la classe dans matiere. Il s'agit bien de créneaux, donc de couples [numMatiere, numCreneau].

ligneCourante=fichier.readline().rstrip("\r\n")
profDeLaClasse={}
while ligneCourante!="":
    ligneCourante=ligneCourante.split(":")
    matiere=ligneCourante[0]
    profDeLaClasse[matiere]=[]
    for i in ligneCourante[1].split(","):
        if i!="": #au cas où le prof de la classe n'a aucun créneau de colle: ligneCourante[1] serait alors ""
            profDeLaClasse[matiere].append( [matiere, int(i)-1])  
    ligneCourante=fichier.readline().rstrip("\r\n")





##Lecture des élèves

#listeEleves[groupe -1] = [ [noms] , [contraintes] ]
fichier.readline()
listeEleves=[]
ligneCourante=fichier.readline().strip()

while ligneCourante!="":
    ligneCourante=ligneCourante.split(":")
    listeEleves.append( [ ligneCourante[1].split(",")  , ligneCourante[2].split(",") ] )
    ligneCourante=fichier.readline().strip()
    
print( len(listeEleves), "groupes lus")
if len(listeEleves)!= nbGroupes:
    print("le nombre de trinomes lus ne correspond pas au nombre de groupes indiqué")


#dictionnaire donnant le groupe de chaque eleve
groupeDeLEleve={}
for g in range (nbGroupes):
    for eleve in listeEleves[g][0]:
        groupeDeLEleve[eleve]=g
        


elevesParGroupe={}
for g in range(nbGroupes):
    for con in listeEleves[g][1]:
        concateDansDico(elevesParGroupe,con, enleveDansListe( listeEleves[g][0],""))

listeContraintes=list(elevesParGroupe.keys())
listeContraintes.sort()

print("nombre d'élèves par groupe :")
for con in listeContraintes:
    print(con, len(elevesParGroupe[con]))
print('\n')

##### Calcul des contraintes

def calculDesContraintes():

    #dictionnaireDesContraintes[nom de la contrainte]=[créneaux impossibles (sous forme texte par exemple M2)]

    # creneauPossible[gpe][mat][num] = un bool

    #Creation du tableau, contenant uniquement des True:
    creneauPossibleInitial=[]
    for i in range(nbGroupes):
        creneauPossibleInitial.append({})
        for mat in listeDesMatieres:
            creneauPossibleInitial[i][mat]=[]
            for k in range(nbCreneaux[mat]):
                creneauPossibleInitial[i][mat].append(True)

    #impossibilités semaines paires
    #Attention: pour l'utilisateur, la première semaine est impaire car c'est la numéro 1
    creneauPossibleInitialSemainePaire=copy.deepcopy( creneauPossibleInitial)
    impossibilitesSemainesPaires=[ [] for g in range(nbGroupes) ]

    for g in range(nbGroupes):
        for contrainte in listeEleves[g][1]:
            if contrainte in dictionnaireDesContraintesSemainesPaires.keys():
                impossibilitesSemainesPaires[g].extend( dictionnaireDesContraintesSemainesPaires[contrainte])

    for g in range(nbGroupes):
        for mat in listeDesMatieres:
            for n in range(nbCreneaux[mat]):
                creneauPossibleInitialSemainePaire[g][mat][n] = not( descriptionCreneaux[mat][n][0] in impossibilitesSemainesPaires[g])


    #impossibilités semaines impaires
    creneauPossibleInitialSemaineImpaire=copy.deepcopy( creneauPossibleInitial)
    impossibilitesSemainesImpaires=[ [] for g in range(nbGroupes)]

    for g in range(nbGroupes):
        for contrainte in listeEleves[g][1]:
            if contrainte in dictionnaireDesContraintesSemainesImpaires.keys():
                impossibilitesSemainesImpaires[g].extend( dictionnaireDesContraintesSemainesImpaires[contrainte])

    for g in range(nbGroupes):
        for mat in listeDesMatieres:
            for n in range(nbCreneaux[mat]):
                creneauPossibleInitialSemaineImpaire[g][mat][n] = not( descriptionCreneaux[mat][n][0] in impossibilitesSemainesImpaires[g])

    return creneauPossibleInitial, creneauPossibleInitialSemainePaire, creneauPossibleInitialSemaineImpaire

creneauPossibleInitial, creneauPossibleInitialSemainePaire, creneauPossibleInitialSemaineImpaire = calculDesContraintes()

            
#On met les deux dans une même liste. Utilisation typique: creneauPossibleInitialSelonParite[ semaine %2].
creneauPossibleInitialSelonParite=(creneauPossibleInitialSemainePaire, creneauPossibleInitialSemaineImpaire)



def affiche(colloscope):
    for s in range(semaineDeDepart-1,semaineFinale):
        ligne="s"+str(s+1)+": "
        for g in range(nbGroupes):
            colle1=colloscope[s][g][0]
            colle2=colloscope[s][g][1]
            ligne+= colle1[0]+str( colle1[1]+1) + colle2[0]+str( colle2[1]+1)
            if len( colloscope[s][g])==2 or colloscope[s][g][2]==[-1,-1]:#si pas de français
                ligne+="   | "
            else:
                colle3=colloscope[s][g][2]
                ligne+=colle3[0]+str( colle3[1]+1)+"  | "
            
        print(ligne)



##création et préremplissage du tableau colloscope
def initialisationDuColloscope(fichier):
    #colloscope[semaine][groupe] renvoie une liste des trois colles. Mis en variable globale.

    #creation du tableau vide
    l=[]
    colloscopeInitial=[]
    for i in range(semaineFinale):
        colloscopeInitial.append([])
        for j in range(nbGroupes):
            colloscopeInitial[i].append( [[" ",-1],[" ",-1],[" ",-1]])





    fichier.readline()
    #lecture du préremplissage par l'utilisateur
    problemes=""
    if prefixe("oui", fichier.readline()):
      print("\n lecture du préremplissage \n")
      for s in range(semaineDeDepart-1, semaineFinale):
        creneauPossible = creneauPossibleInitialSelonParite[ (s+1) %2]
        ligneCourante=fichier.readline().split(":")[1]
        #ligneCourante devrait ressembler à "M  C      L  P      M  S     ...". On a enlevé le "s k:" du début de la ligne.
        print("lecture du préremplissage semaine ",s+1)
        
        for groupe in range(nbGroupes):
            preRempli=[False,False,False]
            matiere=["","",""]
            numCreneau=[-1,-1,-1]
            i=1+9*groupe    #le premier créneau
            if ligneCourante[i:i+2]!="  ":
                preRempli[0]=True
                numCreneau[0]=int(ligneCourante[i:i+2])-1
                matiere[0]= ligneCourante[i-1]
                #print("prérempli: ",numMatiere1,numCreneau1)
                colloscopeInitial[s][groupe][0]=[matiere[0], numCreneau[0] ]
                if not(creneauPossible[groupe][matiere[0]][numCreneau[0]]) or not( contrainteSupplementaires(s,groupe,matiere[0],numCreneau[0],uneSemaineA)) :
                    problemes+="attention : créneau impossible: " + matiere[0] +str(numCreneau[0]+1) + "pour le groupe "+str( groupe+1) +"\n"
                    
            i=4+9*groupe    #le second créneau
            if ligneCourante[i:i+2]!="  ":
                preRempli[1]=True
                numCreneau[1]=int(ligneCourante[i:i+2])-1
                matiere[1]= ligneCourante[i-1]
                colloscopeInitial[s][groupe][1]=[ matiere[1],numCreneau[1]]
                if not(creneauPossible[groupe][matiere[1]][numCreneau[1]]) or not( contrainteSupplementaires(s,groupe,matiere[1],numCreneau[1],uneSemaineA)) :
                    problemes+="\n attention : créneau impossible: " +matiere[1]+str(numCreneau[1]+1) + "pour le groupe "+str( groupe+1)+"\n"
            
            i=7+9*groupe    #le troisième créneau ( a priori français)    
            if ligneCourante[i:i+2]!="  ":
                preRempli[2]=True
                numCreneau[2]=int(ligneCourante[i])-1
                matiere[2]= ligneCourante[i-1]
                colloscopeInitial[s][groupe][2]=[ matiere[2],numCreneau[2]]
                if not(creneauPossible[groupe][matiere[2]][numCreneau[2]]) or not( contrainteSupplementaires(s,groupe,matiere[2],numCreneau[2],uneSemaineA)) :
                    problemes+="\n attention : créneau impossible: " +matiere[2]+str(numCreneau[2]+1)+"pour le groupe " +str(groupe+1)+"\n"

            #vérifions la compatibilité:
            for i,j in [ (0,1), (0,2), (1,2) ]:
                if preRempli[i] and preRempli[j] and not couplesCreneauxPossiblesBool[matiere[i]][matiere[j]][numCreneau[i]][numCreneau[j]]:
                    problemes+="\n Attention : incompatibilité entre "+matiere[i]+str(numCreneau[i]+1)+ " et "+matiere[j]+str(numCreneau[j]+1)+ "pour le groupe "+str( groupe+1)+ " semaine "+str(s+1)+"\n"

                    
      affiche(colloscopeInitial) #Au passage, ceci vérifie si il y a assez de créneaux
      if problemes=="":
          print("\npas de problème détecté dans le préremplissage :)\n\n")
      else:
          print(problemes)
      return(colloscopeInitial)
                    

colloscopeInitial=initialisationDuColloscope(fichier)


#il peut y avoir des lignes inutiles à la fin du fichier, elles ne seront pas lues.
fichier.close()




#####Programmes principaux

groupeMax=-1
cestFichu=False

def essai(semaine, groupe,creneauPossible,derniereColle,colloscope,debug=True):
    global groupeMax,cestFichu
    """
    Parcourt les créneaux possibles et appelle le programme essai. Si le colloscope a étté prérempli, garder uniquement le créneau indiqué.
    Renvoie True si on a reussi à compléter le colloscope et False sinon.
    Dans le cas True, on remplit en outre la case du colloscope
    """
    if cestFichu:
        return(False)
    
    matiere1=matiereVoulue[semaine][groupe][0]
    matiere2=matiereVoulue[semaine][groupe][1]
    if debug:
        if groupe>groupeMax:
            print("je cherche",listeDesMatieres[matiere1],listeDesMatieres[matiere2], "pour le groupe", groupe+1, " semaine ",semaine+1)
            groupeMax=groupe
        if groupe<7:
            print("retour au groupe: ",groupe+1)
    
    aParcourir1=range(derniereColle[groupe][matiere1]+1, nbCreneaux[matiere1]+derniereColle[groupe][matiere1]+1)#on commence à chercher un créneau à partir du dernier créneau qu'a eu le groupe +1
    aParcourir2=range(derniereColle[groupe][matiere2]+1, nbCreneaux[matiere2]+derniereColle[groupe][matiere2]+1)
    
    if colloscope[semaine][groupe][0]!=[" ",-1]:
        matiere1=colloscope[semaine][groupe][0][0] #l'utilisateur peut avoir changé l'ordre des matières en préremplissant le colloscope
        numCreneau1=colloscope[semaine][groupe][0][1]
        if debug:
            print("case 1 semaine",semaine+1, "groupe", groupe+1,"déja remplie avec",listeDesMatieres[matiere1],numCreneau1+1  )
        if not(creneauPossible[groupe][matiere1][numCreneau1]) or not( contrainteSupplementaires(semaine,groupe,matiere1,numCreneau1,uneSemaineA)) :
            print("créneau impossible: " ,matiere1,numCreneau1+1 , "pour le groupe ", groupe+1)
            return(False)
        aParcourir1=[numCreneau1]
    
    if colloscope[semaine][groupe][1]!=[" ",-1]:
        matiere2=colloscope[semaine][groupe][1][0] #
        numCreneau2=colloscope[semaine][groupe][1][1]
        if debug: print("case 2 semaine",semaine+1, "groupe", groupe+1,"déja remplie avec",listeDesMatieres[matiere2],numCreneau2+1  )
        if not(creneauPossible[groupe][matiere2][numCreneau2]) or not( contrainteSupplementaires(semaine,groupe,matiere2,numCreneau2,uneSemaineA)) :
            print("créneau impossible: " ,matiere2,numCreneau2+1 , "pour le groupe ", groupe+1, "la semaine", semaine+1)
            return(False)
        aParcourir2=[numCreneau2]
            
    if colloscope[semaine][groupe][0]!=[" ",-1] and colloscope[semaine][groupe][1]!=[" ",-1] and not(couplesCreneauxPossiblesBool[matiere1][matiere2][numCreneau1][numCreneau2]):
        print("couple de créneaux impossible: ", matiere1,numCreneau1+1 ,matiere2,numCreneau2+1 , "pour le groupe ", groupe+1, "la semaine", semaine+1)
        return(False)


    
    for c1 in aParcourir1:
        numCreneau1=c1%nbCreneaux[matiere1]
        if creneauPossible[groupe][matiere1][numCreneau1] and contrainteSupplementaires(semaine,groupe,matiere1,numCreneau1,uneSemaineA) :
            for c2 in aParcourir2:
                numCreneau2=c2%nbCreneaux[matiere2]
                if couplesCreneauxPossiblesBool[matiere1][matiere2][numCreneau1][numCreneau2]  and creneauPossible[groupe][matiere2][numCreneau2]  and contrainteSupplementaires(semaine,groupe, matiere2,numCreneau2,uneSemaineA):
                    #creneauPossibleSauvegarde=copy.deepcopy(   creneauPossible ) #Ceci était trop lent!
                    derniereColleSauvegarde1=derniereColle[groupe][matiere1]
                    derniereColleSauvegarde2=derniereColle[groupe][matiere2]
                    derniereColle[groupe][matiere1]=numCreneau1
                    derniereColle[groupe][matiere2]=numCreneau2
                    miseAJourCreneauxPossibles(creneauPossible,groupe, matiere1, numCreneau1, matiere2, numCreneau2)
                    if caseSuivante(semaine,groupe,creneauPossible,derniereColle,colloscope,debug):
                        #Si on arrive à compléter le colloscope en ayant mis ce créneau
                        colloscope[semaine][groupe]=[[matiere1,numCreneau1],[matiere2,numCreneau2] ]
                        return(True)
                    else:
                        #sinon, annuler les modifications
                        #creneauPossible=creneauPossibleSauvegarde
                        annuleMiseAJour(creneauPossible,groupe, matiere1, numCreneau1, matiere2, numCreneau2, semaine)
                        derniereColle[groupe][matiere1]=derniereColleSauvegarde1
                        derniereColle[groupe][matiere2]=derniereColleSauvegarde2
    #si on arrive ici, c'est qu'aucun créneau n'était possible
    return(False)

    


def miseAJourCreneauxPossibles(creneauPossible,groupe, matiere1,numCreneau1 , matiere2,numCreneau2):
    """rend ces deux créneaux indisponibles pour les groupes suivants"""
    for g in range(groupe+1, nbGroupes):
        creneauPossible[g][matiere1][numCreneau1]=False
        creneauPossible[g][matiere2][numCreneau2]=False

def miseAJourCreneauxPossiblesAvantAussi(creneauPossible,groupe, matiere1,numCreneau1):
    """rend ce créneau indisponible pour les groupes autres que 'groupe'. """
    for g in range(nbGroupes):
        if g!= groupe:
            creneauPossible[g][matiere1][numCreneau1]=False



def annuleMiseAJour(creneauPossible, groupe, matiere1, numCreneau1 , matiere2, numCreneau2,semaine):
    """ réinitialise la disponibilité de ces deux créneaux pour les groupes suivants"""
    #Le cas où on aurait changé de semaine n'est pas pris en compte. A priori, il  n'intervient pas pour le type de contraintes prises en compte pour l'instant.
    for g in range(groupe+1, nbGroupes):
        if semaine%2==0:#Pour l'utilisateur, semaine impaire
            creneauPossible[g][matiere1][numCreneau1]=creneauPossibleInitialSemaineImpaire[g][matiere1][numCreneau1]
            creneauPossible[g][matiere2][numCreneau2]=creneauPossibleInitialSemaineImpaire[g][matiere2][numCreneau2]
        else:
            creneauPossible[g][matiere1][numCreneau1]=creneauPossibleInitialSemainePaire[g][matiere1][numCreneau1]
            creneauPossible[g][matiere2][numCreneau2]=creneauPossibleInitialSemainePaire[g][matiere2][numCreneau2]




def initialisationDebutDeSemaine(semaine):
    """renvoie le tableau des créneaux possible au début de la semaine."""
    
    creneauPossible=copy.deepcopy(creneauPossibleInitialSelonParite[(semaine+1) %2])
    
    #Voir s'il y a des cases pré-remplies
    for g in range(nbGroupes):
        for n in range(2):
            if colloscopeInitial[semaine][g][n]!=[' ',-1]:
                #print("déjà rempli: groupe ",g+1, listeDesMatieres[ colloscope[semaine][g][n][0]] ,  colloscope[semaine][g][n][1]+1)
                miseAJourCreneauxPossiblesAvantAussi(creneauPossible, g, colloscopeInitial[semaine][g][n][0], colloscopeInitial[semaine][g][n][1] )
    
    return(creneauPossible)



def caseSuivante(semaine, groupe,creneauPossible,derniereColle,colloscope,debug=True):
    """Passe à la case suivante. Renvoie True si on est déjà à la dernière case."""
    global groupeMax
    global cestFichu
    if cestFichu:
        return(False)
    
    if groupe<nbGroupes-1:
        return(essai(semaine, groupe+1,creneauPossible,derniereColle,colloscope,debug))
    
    #Si on arrive ici, c'est qu'on a fini une semaine.
    print("la semaine", semaine+1,"est effectuée")
    
    if semaine<semaineFinale-1:
    #Réinitialiser les impossibilités
        creneauPossible=initialisationDebutDeSemaine(semaine+1)
        if essai(semaine+1,0,creneauPossible, derniereColle,colloscope,debug):
            return(True)
        else:
            print("la semaine ",semaine +2, "est impossible")
            cestFichu=True #La semaine suivante ne marche pas, c'est fichu.
            return(False)
    else: #On a fini!!!
        return(True)





def pgPrincipal(debug=False):
    global groupeMax,cestFichu
    groupeMax=-1
    cestFichu=False
    
    creneauPossible=initialisationDebutDeSemaine(semaineDeDepart - 1 )
                
    #derniereColle[groupe][matiere] renvoie le dernier creneau qu'a eu ce groupe dans cette matiere
    #creation du tableau vide:
    derniereColle=[]
    for g in range(nbGroupes):
        derniereColle.append({})
        for m in listeDesMatieres:
            derniereColle[g][m]=0
    colloscope= copy.deepcopy(colloscopeInitial)
    if essai(semaineDeDepart-1,0,creneauPossible,derniereColle,colloscope,debug):
        return(colloscope)
    else:
        print("pas possible... voici quand même ce que j'ai:")
        return(colloscope)


def avecInitialisationAleatoire(debug=False):
    """lance le programme en initialisant le tableau derniereColle de manière aléatoire.
    """
    global groupeMax    #pour le débugage: groupe maximal atteint
    groupeMax=-1
    cestFichu=False
    
    creneauPossible= initialisationDebutDeSemaine(semaineDeDepart - 1 )
    
    #derniereColle[groupe][matiere] renvoie le dernier creneau qu'a eu ce groupe dans cette matiere
    #creation du tableau vide:
    derniereColle=[]
    for g in range(nbGroupes):
        derniereColle.append({})
        for m in listeDesMatieres:
            derniereColle[g][m]= np.random.randint(0, nbCreneaux[m])
            
    colloscope= copy.deepcopy(colloscopeInitial)
    essai(semaineDeDepart-1,0,creneauPossible,derniereColle,colloscope, debug)  #remplit (si possible) le colloscope par effet de bord.
    return(colloscope)  
    
    


def possibilitesFrancais(colloscope,sortie=None):
    """affiche un tableau avec les créneaux possibles de français. Si l'argument optionnel sortie est présent, on y écrit ce tableau."""
    
    nbCreneauxFrancais=nbCreneaux["F"]
    
    if sortie!=None:
        fichierSortie=open(sortie, 'w')
    
    for s in range(semaineDeDepart-1,semaineFinale):
        aAfficher=""
        if s%2==0:
            aUtiliser= creneauPossibleInitialSemaineImpaire
        else:
            aUtiliser=creneauPossibleInitialSemainePaire
        for g in range(nbGroupes):
            colle1= colloscope[s][g][0]
            colle2=colloscope[s][g][1]
            for nf in range( nbCreneauxFrancais):
                if aUtiliser[g]['F'][nf] and couplesCreneauxPossiblesBool[colle1[0]] ['F'] [colle1[1]] [nf] and couplesCreneauxPossiblesBool[colle2[0]] ['F'] [colle2[1]] [nf]:
                    aAfficher+="F"+str(nf+1)
                else:
                    aAfficher+="  "
            aAfficher+="|"
        print(aAfficher)
        if sortie!=None:
            fichierSortie.write(aAfficher+"\n")




##Programmes secondaires



def sortieTxt(colloscope,chemin="/home/moi/enseignement/info/colloscope/colloscope.txt"):
    sortie=open(chemin,"w")
    for s in range(semaineDeDepart-1,semaineFinale):
        ligne=""
        for g in range(nbGroupes):
            colle1=colloscope[s][g][0]
            colle2=colloscope[s][g][1]
            ligne=ligne+listeDesMatieres[colle1[0]]+str( colle1[1]+1) + listeDesMatieres[colle2[0]]+str( colle2[1]+1)+" "
        sortie.write(ligne+"\n")
    sortie.close()


def sortieLatex(colloscope,chemin="/home/moi/Dropbox/PCSI/2016-2017/colloscope/colloscope.tex"):
    """crée le fichier source latex du colloscope."""
    sortie=open(chemin,"w")
    sortie.write("\\input{entetecours}\n\\usepackage{lscape}\n\\begin{document}\n\\pagestyle{empty}\n\\begin{landscape}\n")
    aujourdhui=date_vers_str( datetime.datetime.now())
    
    sortie.write("\\begin{center}\n Calendrier des séances d'oral, PCSI1, au " +aujourdhui+ "\\end{center}\n\n")
    sortie.write("\\tiny\n\\begin{tabular}{|l|")
    for i in range(nbGroupes):
        sortie.write("c|")
    sortie.write("}\n\\hline\n")
    
    sortie.write("\n%" + str(colloscope)+"\n")
    jour=premierJour
    for s in range(semaineDeDepart-1,semaineFinale):
        
        sortie.write("s"+str(s+1)+" "+ "AB"[(s+1+uneSemaineA+int(s>23))%2]+" le "+str(jour.day)+"/"+str(jour.month))
        for g in range(nbGroupes):
            sortie.write("&")
            for colle in colloscope[s][g]:#Il peut y avoir jusqu'à trois colles (français)
                if colle!=[" ",-1]:sortie.write( colleVersStr(colle))
        sortie.write("\\\\\\hline\n")
        jour= jour + datetime.timedelta(days = 7*(1+semainesSansColle[s]))
    sortie.write("\\hline\n")
    sortie.write("groupe")
    
    for g in range(nbGroupes):
        sortie.write("&"+str(g+1))
    sortie.write("\\\\\n")
    #On écrit le nom des élèves:
    for i in range(3):
        for g in range(nbGroupes):
            sortie.write("&"+listeEleves[g][0][i])
        sortie.write("\\\\\n")
    #sortie.write("contraintes &")
    #On écrit les contraintes de chaque groupe
    for g in range(nbGroupes):
        sortie.write("&")
        for contrainte in enleveDansListe( listeEleves[g][1],"ang"):
            sortie.write(" "+contrainte)
    sortie.write("\\\\\\hline\n")
    sortie.write("\\end{tabular}\n\\medskip\n\n")

    #écriture des créneaux
    sortie.write("\\small\n\\begin{multicols}{3}\n")
    sortie.write("\\begin{itemize}\n")
    for matiere in listeDesMatieres:
        sortie.write("\\item \\begin{itemize}\n")
        for num in range(nbCreneaux[matiere]):
            sortie.write("\\item "+matiere + str(num+1) + " : " + horaire_vers_str(descriptionCreneaux[matiere][num][0]) +" "+ descriptionCreneaux[matiere][num][1]+" "+ descriptionCreneaux[matiere][num][2]+"\n")
        sortie.write( "\\end{itemize}\\medskip\n")
    sortie.write( "\\end{itemize}\n")
    sortie.write( '\\end{multicols}\n')

    sortie.write("\\end{landscape}\n\n")
    
    #version prof
    sortie.write("\\newpage")
    sortie.write("\\begin{tabular}{|l|")
    for s in range(semaineDeDepart-1,semaineFinale):
        sortie.write("c|")
    sortie.write("}\n\\hline\n semaine")
    for s in range(semaineDeDepart-1,semaineFinale):
        sortie.write("&s"+str(s+1))
    sortie.write("\\\\\n")
    
    
    for matiere in listeDesMatieres:
        for numCreneau in range( nbCreneaux[matiere] ):
            colle= [matiere, numCreneau]
            sortie.write( "\\hline\n "+ colleVersStr( colle ))
            for s in range(semaineDeDepart-1,semaineFinale):
                sortie.write("&")
                for g in range(nbGroupes):
                    if  colle in colloscope[s][g]:
                        sortie.write( str(g+1))
                
            sortie.write("\\\\\\hline")
    
    sortie.write("\\end{tabular}\n\n\\end{document}")
    
    
    sortie.close()


def verifProfDeLaClasse(matieresAVerifier,colloscope):
    """compte combien de fois chaque groupe vois le prof de la classe pour les matières contenue dans la liste matiereAVerifier. (exemple: ["M", "P", "S"])
    
    Renvoie une liste type "nbDeFois[matiere][groupe]"    
    Calcule également le nombre de groupes qui n'ont jamais le professeur de la classe.
    Enfin, calcule la moyenne des variances des nombres de fois pour chaque matière.
    """
    nbDeFois={}
    nbDeProblemes=0
    #au final: nbFois[numMatière][numGroupe]
    for matiere in matieresAVerifier:

        nbDeFois[matiere]=[]
        for g in range(nbGroupes):
            n=0
            for s in range(semaineDeDepart-1,semaineFinale):
                if (colloscope[s][g][0] in profDeLaClasse[matiere]) or (colloscope[s][g][1] in profDeLaClasse[matiere]):
                    n=n+1
            nbDeFois[matiere].append(n)
            if n==0:
                #print("le groupe ",g+1," ne voit pas le professeur de la classe pour la matière "+matiere)
                nbDeProblemes=nbDeProblemes+1
        nbDeFois[matiere].append( np.var(nbDeFois[matiere])) #on rajoute la variance à la fin de la liste
    
        
    #Calculons la moyenne des variances
    somme=0
    for matiere in matieresAVerifier:
        somme=somme+nbDeFois[matiere][nbGroupes]
        
    return(nbDeFois, nbDeProblemes, somme/len(matieresAVerifier) )


def pleinDEssais(n,matieresAVerifier):
    """ fait n tentatives avec initialisation aléatoire, et garde la meilleure (au sens du programme verifProfsDeLaClasse). matieresAVerifier est une liste de lettres, ex: ["M","P","S"]."""

    colloscope=avecInitialisationAleatoire()
    statsSauvegardees=verifProfDeLaClasse(matieresAVerifier,colloscope)
    colloscopeSauvegarde=copy.deepcopy(colloscope)
    for i in range(n):
        colloscope=avecInitialisationAleatoire()
        stats=verifProfDeLaClasse(matieresAVerifier, colloscope)
        print(stats[1:])
        
        if stats[1]<statsSauvegardees[1]:
            print("moins de problèmes!")
            statsSauvegardees=stats
            colloscopeSauvegarde=copy.deepcopy(colloscope)
        elif stats[1]==statsSauvegardees[1] and stats[2]<statsSauvegardees[2]:
            print("meilleure variance!")
            statsSauvegardees=stats
            colloscopeSauvegarde=copy.deepcopy(colloscope)
        print("")
    colloscope=colloscopeSauvegarde
    stats=statsSauvegardees
    print(stats)
    affiche(colloscope)
    return(colloscope)

def lectureColloscope(chemin):
    """lit un colloscope depuis un fichier.tex Le tableau doit être encadré par deux lignes commençant par '\hline'."""
    fichier=open(chemin, 'r')
    ligneCourante=fichier.readline()
    while not prefixe("\\hline", ligneCourante):
        ligneCourante=fichier.readline()
    ligneCourante=fichier.readline()
    
    s=semaineDeDepart-1
    while ligneCourante.rstrip("\n")  !="\\hline":
        ligneCourante=ligneCourante.split("&")[1:]
        print(ligneCourante)
        for g in range(nbGroupes):
            colle1 = [ dictionnaireMatieres[ligneCourante[g][0]], int(ligneCourante[g][1])-1 ]
            colle2 = [ dictionnaireMatieres[ligneCourante[g][2]], int(ligneCourante[g][3])-1 ]
            colloscope[s][g]=[colle1,colle2]
        ligneCourante=fichier.readline()
        s+=1

print("chargement des données effectué.\n Taper pgPrincipal() pour lancer les calculs.\n Taper affiche(colloscope) pour afficher les résultats.\n Utiliser sortieLatex pour exporter le résultat en latex, sortieTxt pour exporter dans un fichier texte.\n Utiliser verifProfDeLaClasse pour voir si chaque groupe voit chaque professeur de la classe.\n Enfin, pleinDEssais lance plusieurs essais avec initialisation aléatoire, et garde le meilleur, au sens de verifProfsDeLaClasse.\n\n" )






    
