#! /usr/bin/python3
# -*- coding: utf-8 -*-

import unicodedata




def enleveDansListe(l,x):
    """ *renvoie* la liste obtenue en enlevant x de l"""
    return( [ t for t in l if t != x])


def prefixe(p,m):
    """regarde si p est un préfixe de m."""

    l=len(p)
    lm=len(m)
    if l>lm:
        return(False)
    
    for i in range(l):
        if p[i]!=m[i]:
            return(False)
    return(True)

def prefixeListe(L,m):
    """regarde si un des éléments de L est préfixe de m."""
    for p in L:
        if prefixe(p,m):
            return(True)
    return(False)


def ajouteDansDico(x,d,cle):
    """ajoute x dans le dictionnaire d à l'entrée cle, s'il n'y est pas déjà. Il doit s'agir d'un dictionnaire de listes."""
    if cle in d.keys():
        if not x in d[cle]:
            d[cle].append(x)
    else:
        d[cle]=[x]

def afficheDico(d):
    for c in d.keys():
        print (c," : ",d[c])


def remplaceCaracteresSpeciaux(mot,remplacement="_"):
    res=""
    for lettre in mot:
        if unicodedata.category(lettre) == 'Ll':
            res+=lettre
        else:
            res+=remplacement
    return(res)

def enleveCaracteresSpeciaux(mot):
    res=""
    for lettre in mot:
        if unicodedata.category(lettre) == 'Ll':
            res+=lettre
    return(res)

def echappe(car):
    """échappe le caractère car si besoin"""
    if car=="\t":
        return("\\t")
    elif car=="\n":
        return("\\n")
    else:
        return(car)


def date_vers_str(d):
    return( str(d.day)+"/"+str(d.month)+"/"+str(d.year))


def enleveDoublons(l):
    """enlève les doublons dans l"""
    R=[]
    n=len(l)
    for i in range(n):
        if not (l[i] in l[(i+1):]):
            R.append(l[i])
    return(R)

def concatSansDoublon( l1, l2):
    for x in l2:
        if not x in l1:
            l1.append(x)

def ligneSuivante(fichier):
    """va à la prochaine ligne non vide, et renvoie celle-ci."""
    ligneCourante=fichier.readline().lstrip(" ")
    while  ligneCourante== "\n":
        ligneCourante=fichier.readline().lstrip(" ")
    return( ligneCourante)
        


def partition(T):
    n=len(T)
    return( T[0:n//2], T[n//2:n] )


def fusion(T1,T2,ordre = lambda x,y: x<y):
    T=[]
    compteur1=0
    compteur2=0
    while compteur1!=len(T1) and compteur2!=len(T2):
        if ordre(T1[compteur1],T2[compteur2] ):
            T.append(T1[compteur1])
            compteur1+=1
        else :
            T.append(T2[compteur2])
            compteur2+=1

    #on rajoute la fin de la liste
    T+= T1[compteur1:]
    T+= T2[compteur2:]
    return T 


def triFusion(T,ordre=lambda x,y: x<y):
    if len(T)<2:
        return(T)
    else:
        (TG,TD) = partition(T)
        return fusion(triFusion(TG,ordre), triFusion(TD,ordre),ordre)
