from bibNeurones import *

# Ceci charge en particulier les variables globales TOUT, CATÉGORIE, NLIGNES, NCOLS, NSORTIES, et initialis aléatoirement une matrice P.



### Partie 2 : perceptron simple


## 2.1 Lecture d'une image


def signal_reçu(k, Im, P):
    """
    Entrée : Im, image
             P, matrice des coefficients synaptiques
             k ∈ [| 0, Ns[|
    Sortie : A(k, Im, P) """
    
    S=0
    for i in range(NLIGNES):
        for j in range(NCOLS):
            S += P[k][i][j]*Im[i][j]
    return S




def sorties_activées(Im, P):
    """
    Entrée : Im, image
             P, matrice des coefficients synaptiques

    Sortie : tableau des synapses de sortie activées
    """

    # garder tous les k tq signal_reçu(k, Im, P) > 1
    S_activ = []
    for k in range(NSORTIES):
        if  signal_reçu(k, Im, P) > 1:
            S_activ.append(k)
    return S_activ


# En une ligne
def sorties_activées(Im, P):
    """
    Entrée : Im, image
             P, matrice des coefficients synaptiques

    Sortie : tableau des synapses de sortie activées
    """
    return [ k for k in range(NSORTIES) if signal_reçu(k, Im, P) > 1 ]



#test
sorties_activées( un, P)


## Correction des poids, version 1

#Taux de convergence
η=0.1


def litUneImage(Im, P, k0):
    """
    Entrée : Im, image noir et blanc
             P, matrice des coefficients synaptiques
             k0, indice de la catégorie de l'image lue
    Sortie : le booléen :«il y a eu au moins une erreur de lecture»
    Effet de bord : modifie les cases de P selon la méthode décrite dans le pdf.
    """

    # ∀ k ∈ [|0, Ns[| :
    #   - si sorties_activées( Im, P) et k≠k0, il faut réduire les poids des synapses concernées
    #   - si non (sorties_activées( Im, P)) et k==k0, il faut augmenter les poids des synapses concernées.
    erreur=False
    for k in range(NSORTIES):
        if k==k0:
            if signal_reçu(k0,Im,P)<1:
                # Neurone pas activé alors qu'il aurait du : on augmente les coeff
                erreur=True
                corrigeNeuronesConcernés(Im, P, k, η)
                        
        else: #k différent de k0
            if signal_reçu(k,Im,P)>=1:
                # Neurone activé alors qu'il n'aurait pas du : on diminue les coeff
                erreur=True
                #print(f"correction pour k ={k}")
                corrigeNeuronesConcernés(Im, P, k, -η)
    return erreur



def corrigeNeuronesConcernés(Im, P, k, cor):
    """ Entrée : Im, image
             P, matrice des coefficients synaptiques
             k ∈ [|0, Ns[|
             cor, un flottant
    Sortie : rien
    Effet de bord : ajoute cor dans P[i][j][k] pour tout (i,j) tel que IM[i][j]==1
    """
    
    for i in range(NLIGNES):
        for j in range(NCOLS):
            if Im[i][j]==1:
                P[k][i][j] += cor


                

def litPlusieursImages(Ims, P):
    """ 
    Entrée : P comme d'habitude
             Ims un tableau de couples (image, indice de sa catégorie)
    Sortie : le booléen : «il y a eu au moins une erreur à la lecture d'au moins une image »
    Effet : applique litUneImage à chaque image contenue dans Ims
    """
    erreur=False
    for (Im, k0) in Ims :
        if litUneImage(Im,P,k0):
            erreur=True
        # erreur = erreur or  litUneImage(Im,P,k0)
    return erreur



                
def apprentissage( Ims ):
    """ 
    Entrée : Ims un tableau de couples (image, indice de sa catégorie)
    Sortie : matrice des coefficients stochastiques permettant de reconnaître la catégorie des images contenues dans Ims.

    Cette matrice est obtenue en l'initialisant aléatoirement (fonction init_P) puis en appelant lisPlusieursImages tant qu'il y a au mouns une erreur dans la lecture d'au moins une image.
    """


    erreur=True #Indique s'il y eu au moins une erreur en lisant une des images
    while erreur :
        erreur=litPlusieursImages(Ims, P)

    return P



## Programme final

def détection(Im, P, catégories):
    """ 
    Entrée : une image
             P, la matrice des coeff d'un réseau *déjà entraîné*
             catégories, la tableau des catégories d'image existantes.
    Sortie : la catégorie de Im.
    """
    pass
Pfinal=apprentissage(TOUT)
unRaté=[[1, 1, 1], [1, 1, 0], [0, 1, 0], [0, 1, 0], [0, 1, 0]]
