#from compareTri import *


# -*- coding: utf-8 -*-
"""
Created on Thu Sep 24 10:41:23 2020

@author: cyril.charignon
"""

#### Chapitre 2 : tris ####

# Révision : recherche dichotomique


def appartient_dicho(x,t):
    """
    Précondition : t est trié.
    Indique si x€t. """
    
    deb, fin = 0, len(t)  # On recherche dans t[deb:fin]
    trouvé = False
    
    while deb<fin and not trouvé : # Zone de recherche non vide
        m= (deb+fin)//2
        if x < t[m]:
            fin=m
        elif x > t[m]:
            deb=m+1
        else: # x == t[m]
            #On a trouvé x :) 
            trouvé = True
    
    return trouvé
    
# Rappel : cxté O(log(len(t)))
    
#Version récursive
    
def dichoAux(x, t, deb, fin):
    """ Indique si x € t[deb:fin]. """
    
    #cas d'arrêt
    if fin == deb :
        return False
    #cas général
    else:   
        m=(deb+fin)//2
        if x < t[m]:
            return dichoAux(x, t, deb, m)
        elif x > t[m]:
            return dichoAux(x, t, m+1, fin)
        else:
            return True
        
def dichoFinale(x,t):
    return dichoAux(x,t,0, len(t))




# Exemple d'utilisation d'une procédure de tri en place,
# et d'une fonction de tri pas en place :
# Calcul de médiane

# On suppose qu'on dispose de deux pg :
# - triEnPlace (procédure)
# - triPasEnPlace (fonction)

# Déduisons-en un pg pour calculer une médiane

def mediane(t):
    t=triEnPlace(t)
    # Maintenant, t == None car triEnPlace ne renvoie rien
    return t[len(t)//2] # erreur ici



# Version correcte:
def mediane(t):
    triEnPlace(t)
    # Maintenant, t est trié
    return t[len(t)//2]

# On peut préférer faire une copie pour éviter de modifier
# le tableau envoyé par l'utilisateur:
import copy
def mediane(t):
    copie = copy.deepcopy(t)
    triEnPlace(copie)
    # Maintenant, t est trié
    return copie[len(t)//2]


# Et avec la fonction triPasEnPlace :
def mediane(t):
    ttrié=triPasEnPlace(t)
    # Maintenant, ttrié est un nouveau tableau, avec les m^emes éléments
    # que t mais dans l'ordre
    return ttrié[len(t)//2]


# rema : dans Python
# tri en place : t.sort()
# tri pas en place sorted(t)



## Tri par insertion
    

def triInsertion(t):
    
    for i in range(len(t)):
        # Ici, t[0:i] est trié
        insereASaPlace(t,i) # Ceci insére t[i] à la bonne place dans t[0:i]
        # Maintenant, t[0:i+1] est trié


def cherchePlace(t,i):
    """ 
    Précontion : t[0:i] est trié
    Sortie : l'indice if tel que t[j-1] <= t[i] < t[j]
    (enlever la première cond si j==0)
    """
    j = i
    x=t[i]
    while j>0 and  t[j-1] > x : # Attention à l'ordre des tests
        j -= 1
    # Sortie de boucle:
    # # j==0 ou t[j-1] <= x
    # # De plus, la condition du while était vraie à l'itération précédente
    # # càd pour j+1, donc t[j]>x
    return j


def insereASaPlace(t,i):
    """ 
    Précontion : t[0:i] est trié
    Effet : déplace t[i] vers la gauche pour que t[0:i+1] soit trié
    """
    i_f = cherchePlace(t,i)
    x=t[i]
    for k in range(i-1, i_f-1,-1):
        t[k+1]=t[k]
    t[i_f]=x


# En combinant insereASaPlace et cherchePlace en une seule fonction:
def insereASaPlace(t,i):
    """ 
    Précontion : t[0:i] est trié
    Effet : déplace t[i] vers la gauche pour que t[0:i+1] soit trié
    """
    x=t[i]
    j=i
    while j>0 and  t[j-1] > x : # Attention à l'ordre des tests
        j -= 1
        t[j+1]=t[j]
    t[j]=x
    
    
    
    
### Tri fusion ###    
    
    
def fusion (t1,t2):
    i1,i2=0,0
    res=[]
    while i1<len(t1) and i2<len(t2):
        if t1[i1]<=t2[i2]:
            res.append(t1[i1])
            i1+=1
        else:
            res.append(t2[i2])
            i2+=1
    res.extend(t1[i1:])
    res.extend(t2[i2:])
    return res
        
    

def trifusion (t):
    if len(t)<=1:
        return t
    else:
        n=len(t)
        t1, t2 = t[0:n//2], t[n//2:] #diviser
        T1Trié=trifusion(t1)     #on trie la première moitié du tableau t
        T2Trié=trifusion(t2)     #on trie la deuxième moitié du tableau t
        return fusion (T1Trié,T2Trié) # régner
    
        
# ex 5 pour le 8/10
        
    
    
#cxté de la méthode naïve : O(n**2)
        
# En triant le tab au préalable:


def distance_min(t):
    n=len(t)
    ttrié=trifusion(t)
    dmin=ttrié[n-1]-ttrié[0]
    a=ttrié[0]
    b=ttrié[n-1]
    for i in range(0,n-1):
        if (ttrié[i+1]-ttrié[i])<dmin:
            dmin=ttrié[i+1]-ttrié[i]
            b=ttrié[i+1]
            a=ttrié[i]
    return a,b,dmin
#cxté :  O(nlog n) + O(n) = O(nlog n)


# ex 6
def estDansAPartirDe(x,t,deb):
    """ Indique si x€t[deb:]
    cxté en O(len(t)-deb)
    """
    # return x in t[deb:]  -> Ceci n'est pas optimal car cela necessite de recopier une tranche de tableau
    trouvé=False
    for i in range(deb, len(t)):
        if t[i]==x:
            trouvé=True
    return trouvé


def sansDoublon(t):
    """ Renvoie un nouveau tableau contenant les éléments de t 
    une seule fois chacun.
    cxté O(len(t)**2)."""
    res=[]
    for i in range(0,len(t)):
        if not estDansAPartirDe(t[i], t, i+1) : # O(len(t)-i-1)
            res.append(t[i])
    return res


# En triant :
def sansDoublonOpti(t):
    tTrié = trifusion(t)  # O(nlog n)
    res=[]
    for i in range(0, len(t)-1):
        if tTrié[i]!=tTrié[i+1]:
            res.append(tTrié[i])
    res.append(tTrié[-1])
    return res

#cxté :  O(nlog n) + O(n) = O(nlog n)

## ex 3
def retourné(t):
    t_retourné =[]
    for i in range(len(t)-1, -1, -1):
        t_retourné.append(t[i])
    return t_retourné

def retourne(t):
    n=len(t)
    for i in range(n//2):
        t[i], t[n-1-i] = t[n-i-1], t[i]
        

# (n+1).2) : Version naïve du tri de Hoare
    

def segmente(t,pivot):
    """ Renvoie deux tableaux : les éléments <= pivot et les éléments > pivot"""
    petits, grands =[], []
    
    for x in t:
        if x<=pivot:
            petits.append(x)
        else:
            grands.append(x)
    return petits, grands
    # cxté : len(t) comparaisons, donc O(len(t))


def triSegNaïf(t):
    if len(t) <= 1:
        return t
    else:
        pivot = t.pop()
        petits, grands = segmente(t, pivot)
        petitsTriés = triSegNaïf(petits)
        grandsTriés = triSegNaïf(grands)
        return petitsTriés + [pivot]+ grandsTriés

# Ce pg a plusieurs défauts :
# Occupe de la mémoire.
# renvoie un nv tableau *et* modifie l'ancien



# Programmons la segmentation en place
        
def transpose(t,i,j):
    t[i], t[j] = t[j], t[i]

def segmenteEntre(t, deb, fin, iPivot):
    """ Segmente t[deb:fin] en utilisant t[iPivot] comme pivot
    et renvoie la position finale du pivot. """
    
    pivot=t[iPivot]
    transpose(t, iPivot, fin-1) # On met le pivot en dernière case
    i, j = deb, fin-1
    
    while i<j :
        #Invariants de boucle
        # les éléments de t[deb:i] sont <= pivot
        # les éléments de t[j:fin] sont > pivot
        # le pivot est dans t[fin]
        if t[i] <= pivot :
            i+=1
            # les éléments de t[deb:i] sont toujours <= pivot
            # et j n'a pas changé
        else:
            transpose(t,i,j-1)
            # Maintenant, les éléments de t[j-1:fin] sont > pivot
            j-=1
            
    transpose(t, i, fin-1) # On met le pivot à sa place finale
    
    return i

# Passons à la procédure finale
def trieEntre(t, deb, fin):
    """ Trie en place t[deb:fin] selon l'algo du tri par segmentation."""
    
    if fin-deb <= 1:
        None
    else:
    
        # 1) Diviser
        iPivot = segmenteEntre(t, deb, fin, fin-1) # On prend arbitrairement le dernier élément comme pivot
        # Attention : la ligne ci-dessus a des effets : t est modifié
        # et on récupère la place iPivot du pivot.
        
        
        # 2) Appels récursifs
        trieEntre(t, deb, iPivot)
        trieEntre(t, iPivot+1, fin)
        # NB: le pivot est à sa place finale : ne l'inclure dans aucun
        # appel réc -> le pg pourrait ne pas terminer
        
        # 3) Régner
        # Rien à faire : t[deb:fin] est déjà trié !

test=[5,8,7,4,5,9,5,1,0]

def trieSeg(t):
    trieEntre(t, 0, len(t))





## 17
    
def iEmeElementEntre(t, i, deb, fin):
    """ Renvoie le (i+1)-ème plus petit élément de t
    en supposant qu'il est dans t[deb:fin]
    """

    iPivot = segmenteEntre(t, deb, fin, fin-1)
    if i == iPivot:
        return t[iPivot]
    elif i < iPivot:
        return iEmeElementEntre(t, i, deb, iPivot)
    else:
        return iEmeElementEntre(t, i, iPivot+1, fin)
    
    
    