﻿#! /usr/bin/python3
# -*- coding: utf-8 -*-

import matplotlib.pyplot as plt
import numpy as np


# Chargement d'une image
poireaux1 = plt.imread("Champ_poireaux.jpg")



# Affichage d'une image
#plt.imshow(poireaux1)
#plt.show()


def conversion_gris(im):
    """ Entrée : une image couleur
        Sortie : cette image en niveaux de gris """
    n,p,_ = im.shape
    res=np.zeros( (n,p), dtype = int )
    for i in range(n):
        for j in range(p):
            res[i,j] = int( 0.299*im[i,j,0] + 0.587*im[i,j,1] + 0.114*im[i,j,2])
    return res

poireaux_gris = conversion_gris(poireaux1)
            
    



# Pour afficher une image en niveaux de gris:
# plt.imshow(image_grise, cmap=plt.get_cmap('gray'))

from cours2020 import trieSeg


def seuil(im):
    """ Entrée : une image en niveaux de gris
        Sortie : la valeur médiane des niveaux de gris des pixels de im
        """
        
    # étape 1 : mettre tous les pixels en vrac dans un tableau simple
    t=[]
    n,p = im.shape
    for ligne in im:
        for pix in ligne:
            t.append(pix)
    
    # étape 2 : médiane de ceci
    trieSeg(t)
    return t[n*p//2]


def noir_et_blanc(im):
    """Entrée : une image en niveaux de gris 
       Sortie : une image en noir et blanc
       """
    n,p = im.shape
    res=np.zeros( (n,p), dtype = bool ) #True signifie un pixel noir
    
    s= seuil(im)
    for i in range(n):
        for j in range(p):
            if im[i,j] <= s:
                res[i,j]=True
    return res

poireaux_nb = noir_et_blanc(poireaux_gris)


def nb_pixels_noirs(im, j0, j1):
    """
    Entrée : image noire et blanche
    Renvoie le nb de pixels noirs sur la droite d'équation
    j == j0 + (j1-j0)/(n-1)*i  , où n=len(im)
    """
    
    n,p=im.shape
    res=0
    for i in range (n):
        j=((j1-j0)/(n-1))*i + j0
        if im[i, round(j)]==1:
            res+=1
    return res


def détection_rang_droit (im):
    n,p = im.shape
    nb=0
    res=(0,0)
    for j0 in range (round((p/2)-(p/7)),p-1):
        for j1 in range (j0+1,p):
            nb_noirs = nb_pixels_noirs(im, j0, j1)
            if nb_noirs > nb:
                nb = nb_noirs
                res = (j0,j1)
    return res


# Affichage final
plt.imshow(poireaux1)
plt.plot([95,230], [0, 193])
plt.show()
