# -*- coding:utf-8 -*-

# Amélioration : ranger les mots selon leur longueur

exemple=[
    list(" a  a   "),
    list("orateurs"),
    list(" c# r   "),
    list(" ac#il# "),
    list("#cafeier"),
    list("chianti#"),
    list("rosi# re"),
    list("ansee#en"),
    list(" #enta#v"),
    list("ac#carpe"),
    list(" o e#dur"),
    list("tri#ours")
    ]
grille_vide = [
    list("        "),
    list("        "),
    list("  #     "),
    list("   #  # "),
    list("#       "),
    list("       #"),
    list("    #   "),
    list("     #  "),
    list(" #    # "),
    list("  #     "),
    list("    #   "),
    list("   #    ")
    ]

def affiche(grille):
    for ligne in grille:
        print("".join(ligne))


### est_possible_h ###
def est_possible_h(g,i,j,m):
    
    """ Indique si on peut placer le mot m à partir de la case (i,j) horizontalement."""
    res = True
    p = len(g[0])
    for k in range(len(m)):
        if j+k>=p or g[i][j+k]=="#" or (g[i][j+k] not in [" ",m[k]]) :
            res=False
    k=len(m)
    return res and (j+k==p or g[i][j+k]=="#")
### fin ###

### est_possible_v ###
def est_possible_v(g,i,j,m):
    """ Indique si on peut placer le mot m à partir de la case (i,j) horizontalement."""
    res = True
    n = len(g)
    for k in range(len(m)):
        if i+k>=n or g[i+k][j]=="#" or (g[i+k][j] not in [" ",m[k]]) :
            res=False
    k = len(m)
    return res and (i+k==n or g[i+k][j]=="#")
### fin ###
def est_possible(g,i,j,d,m):
    return (d==0 and est_possible_h(g,i,j,m)) or (d==1 and est_possible_v(g,i,j,m))

### écrit_h ###
def écrit_h(g,i,j,mot):
    for k in range(len(mot)):
        g[i][j+k] = mot[k]
### fin ###
def écrit_v(g,i,j,mot):
    for k in range(len(mot)):
        g[i+k][j] = mot[k]
def écrit(g,i,j,d,mot):
    if d==0:
        écrit_h(g,i,j,mot)
    else:
        écrit_v(g,i,j,mot)

import re
def sans_accent(mot):
    """ Renvoie le mot sans accent et en minuscules."""
    mot_e = re.sub( "[éèêë]","e",mot.lower())
    mot_eu =  re.sub( "[ùûü]","u",mot_e)
    mot_euo = re.sub("[ôö]","o",mot_eu)
    mot_euoa = re.sub("[àâä]","a",mot_euo)
    mot_euoai = re.sub("[ï]","i",mot_euoa)
    mot_euoaic = re.sub("[ç]","c",mot_euoai)
    return mot_euoaic

def mots_extraits(chemin="/home/moi/enseignement/Informatique/bibs/mots_francais.txt"):
    f=open(chemin)
    res=[]
    déjà_vu = {} #Pour éliminer les doublons venant des accents supprimés.
    for ligne in f:
        mot = sans_accent(ligne.strip())
        if not mot in déjà_vu:
            res.append(mot)
            déjà_vu[mot]=1
    return res

TOUS_LES_MOTS = mots_extraits()
#TOUS_LES_MOTS.extend( list("bpovdljzwauiectsrnmyxkqghf"))

def mot_rempli(g,i,j,d):
    """ Indique si le mot en position (i,j,d) est déjà rempli dans g"""
    if d==0:
        for j2 in range(j, len(g[0])):
            if g[i][j2]==" ":
                return False
            elif g[i][j2]=="#":
                return True
        return True

    else:
        for i2 in range(i, len(g)):
            if g[i2][j]==" ":
                return False
            elif g[i2][j]=="#":
                return True
        return True

### cases_début_h ###
def cases_début_h(g):
    n=len(g)
    p=len(g[0])
    res=[]
    for i in range(n):
        for j in range(p-1): # p-1 car je ne veux pas de mots de une seule lettre
            if g[i][j]!="#" and (j==0 or g[i][j-1]=="#") and g[i][j+1]!="#" and not mot_rempli(g,i,j,0):
                res.append((i,j))
    return res
### fin ###


def cases_début_v(g):
    n=len(g)
    p=len(g[0])
    res=[]
    for j in range(p):
        for i in range(n-1):
            if g[i][j]!="#" and (i==0 or g[i-1][j]=="#") and g[i+1][j]!="#" and not mot_rempli(g,i,j,1):
                res.append((i,j))
    return res

### cases_début ###
def cases_début(g):
    return [(i,j,0) for (i,j) in cases_début_h(g)] + [(i,j,1) for (i,j) in cases_début_v(g)]
### fin ###

### nv_possibles ###
def nv_possibles(n,p):
    return [ [[[],[]] for j in range(p)] for u in range(n)]
### fin ###

### init_possibles ###
def init_possibles(g, bavard=True):
    n = len(g)
    p = len(g[0])
    à_remplir = cases_début(g)
    possibles = nv_possibls(n,p)
    print("Recherche des mots possibles")
    for (i,j,d) in à_remplir:
        if bavard : print(f"  Case {i},{j}, direction {d}")
        possibles[i][j][d] = [mot for mot in TOUS_LES_MOTS if est_possible(g,i,j,d,mot)]
    print("Initialisation des mots possibles terminée.\n")
    return possibles
### fin ###

### prochaine_case ###
def prochaine_case( à_remplir, possibles):
    """ 
    Renvoie un triplet ( i,j, dir) indiquant une case où il y a le minimum de possibilités. dir indique la direction, 0 pour horizontal, et 1 pour vertical.
    """
    (i,j,d) = à_remplir[0]
    mini = len(possibles[i][j][d])
    res = (i,j,d)
    for (i,j,d) in à_remplir :
        if len(possibles[i][j][d]) < mini:
            mini = len(possibles[i][j][d])
            res= (i,j,d)
    return res
### fin ###


def avancé(i,j,d,l):
    """ Renvoie la case atteinte en partant de (i,j) dans la direction dpendant l cases."""
    if d==0:
        return (i,j+l)
    else:
        return (i+l,j)

### finale ###
import copy
def résolution(g, possibles=None, bavard=True):
    n= len(g)
    p=len(g[0])
    if possibles==None :
        possibles = init_possibles(g, bavard=bavard)
    else:
        possibles = copy.deepcopy(possibles)
    à_remplir = cases_début(g)

    def màj(i,j,d,mot):
        """
        Écrit mot en (i,j,d).
        Met à jour possibles.
        Supprime (i,j,d) de à_remplir.
        
        Renvoie : 
            (La liste des (i2,j2) ou une lettre a été écrite, 
             La liste des quadruplets (i2,j2,d2, m) de mots supprimés de possibles)
        
        """
        
        à_remplir.remove((i,j,d))

        cases_écrites=[]
        for l in range(len(mot)):
            i2, j2 = avancé(i,j,d,l)
            if g[i2][j2]==" ":
                g[i2][j2]=mot[l]
                cases_écrites.append((i2, j2))

        mots_supprimés=[]
        if d==0:
            j_concernés = [j2 for (_,j2) in cases_écrites]
        else:
            i_concernés = [i2 for (i2,_) in cases_écrites]
        for (i2,j2,d2) in à_remplir:
                if d!=d2 and (d==0 and j2 in j_concernés or d==1 and i2 in i_concernés) :
                    nv_poss = []
                    for m in possibles[i2][j2][d2]:
                        if est_possible(g,i2,j2,d2,m):
                            nv_poss.append(m)
                        else:
                            mots_supprimés.append( (i2,j2,d2,m) )
                    possibles[i2][j2][d2] = nv_poss
                            
        return cases_écrites, mots_supprimés
                                        
                        

    def annule_changements(i,j,d,diff):
        """ Prend les données renvoyées par màj, et remet g, à_remplir et possibles dans l'état précédent cet appel à màj."""

        for (i2,j2) in diff[0]:
            g[i2][j2]=" "
        for (i2,j2,d2,m) in diff[1]:
            possibles[i2][j2][d2].append(m)
        à_remplir.append((i,j,d))
        

    #Fonction de backtracking pour objets mutables
    print("Départ du backtracking")
    def aux(prof):
        """ prof indique la profondeur de l'appel actuel dans l'arbre des appels. Autrement dit c'est le nombre de mots inscrits dans la grille. Cet argument ne sert que pour l'affichage."""
        if à_remplir == []:
            return True
        else:
            (i,j,d) = prochaine_case(à_remplir, possibles)
            if len(possibles[i][j][d]) == 0:
                return False
            else:
                for mot in possibles[i][j][d] :
                    # On essaie d'écrire mot en (i,j,d)
                    if bavard : print(f"{' '*prof}Écriture de {mot} en {i,j,d}")
                    diff = màj(i,j,d,mot)
                    if aux(prof+1):
                        return True
                    else:
                        if bavard:print(f"{' '*prof}Effaçage de {mot} en {i,j,d}")
                        annule_changements(i,j,d,diff)
                return False #aucun mot n'a fonctionné
                    
    return aux(0)
### fin ###
