# -*- coding:utf-8 -*-

def comparaison0(à_deviner, essai):
    """
    Version simplifiée de la fonction qui compare une combinaison essai à la combinaison à deviner.
    """
    res=0
    for x in essai:
        if x in à_deviner:
            res+=1
    return res


def comparaison01(à_deviner, essai):
    """
    Dans cette version, un élément de à_deviner ne peut être compté deux fois. 
    Par exemple comparaison01( [0,1,2,3], [0,0,4,5]) renvoie 1 et non 2 comme la fonction précédente.
    """
    res=0

    for i in range(len(essai)):
        j=0
        while j<len(à_deviner) and essai[i]!=à_deviner[j]:
            j+=1
        #sortie de boucle :
        # j==len(à_deviner) ou essai[i]==à_deviner[j]
        if j<len(à_deviner):
            #donc dans ce cas, essai[i]==à_deviner[j]
            res+=1
            à_deviner[j]=-1 # Pour ne pas recompter cet élément par la suite.
    return res



def comparaison( à_deviner, essai):
    """ La vraie fonction de comparaison entre l’essai et la combinaison à deviner."""
    res=[0,0] # [nb de bien placés, nb de présents mais mal placés]

    # Comme je vais modifier à_deviner et essai dans la suite, il faut que je les remplace par des copies pour éviter de modifier les tableaux envoyés par l’utilisateur de cette fonction.
    à_deviner=à_deviner.copy()
    essai=essai.copy()
    
    # Recherche des couleurs présentes et bien placées
    for i in range(len(essai)):
        if essai[i]==à_deviner[i]:
            essai[i]=-2
            à_deviner[i]=-1
            res[0]+=1

    # Recherche des couleurs présentes mais mal placées. Comme dans la fonction précédente.
    for i in range(len(essai)):
        j=0
        while j<len(à_deviner) and essai[i]!=à_deviner[j]:
            j+=1
        if j<len(à_deviner):
            res[1]+=1
            à_deviner[j]=-1
    return res


def toutesLesCombinaisons(n,k):

    def prochaineCombinaison(c):
        """
        Entrée : une combinaison c
        Sortie : la combinaison suivante, en considérant c comme un nombre écrit en base k avec les unités à droite. Renvoie la combinaison nulle une fois que toutes les combinaisons ont été obtenues.
        """
        i=0
        res=[]
        while i<len(c) and c[i]==k-1:
            res.append(0)
            i+=1
        if i<len(c):
            res.append(c[i]+1)
        res.extend(c[i+1:]) # On rajoute la fin de c non modifiée
        return res

    c0 = [0 for i in range(n)]
    res=[c0]
    c=prochaineCombinaison(c0)
    while c != c0:
        res.append(c)
        c=prochaineCombinaison(c)
    return res


# Version récursive
def toutesLesCombinaisons(n, k):
    if n ==0:
        return [[]]
    else:
        c_n_moins_1 = toutesLesCombinaisons(n-1, k)
        res=[]
        for c in c_n_moins_1:
            for x in range(k):
                res.append(c+[x])
        return res


def combinaisons_compatibles(combs, essai, bpmp):
    """
    Entrée : combs une liste de combinaisons
             essai une combinaison
             bpmp, le couple (bien placés, mal placées) renvoyé par comparaison entre la combinaison à deviner et essai.
    Sortie : liste des éléments de combs qui donnent le résultat bpmp si on les compare à essai
    """
    res=[]
    for c in combs:
        if comparaison(c, essai) == bpmp:
            res.append(c)
    return res

from numpy.random import randint

def simulation(n,k, bavard=0):
    à_deviner = [randint(k) for _ in range(n)]
    nb_tours=0
    possibilités = toutesLesCombinaisons(n, k)
    if bavard>0:
        print("Combinaison à deviner", à_deviner)
    while len(possibilités)>1:
        essai = possibilités[0]
        bpmp=comparaison(à_deviner, essai)
        possibilités = combinaisons_compatibles(possibilités, essai, bpmp)
        nb_tours+=1
        if bavard>0:
            print(f"Tour {nb_tours}, il reste {len(possibilités)} possibilités qui sont {possibilités}.\n", essai, bpmp,"\n")
    return nb_tours, possibilités[0]
